<?php

namespace CUCM\EnumType;

/**
 * This class stands for XDistributeAlgorithm EnumType
 * @subpackage Enumerations
 */
class XDistributeAlgorithm
{
    /**
     * Constant for value 'Top Down'
     * @return string 'Top Down'
     */
    const VALUE_TOP_DOWN = 'Top Down';
    /**
     * Constant for value 'Circular'
     * @return string 'Circular'
     */
    const VALUE_CIRCULAR = 'Circular';
    /**
     * Constant for value 'Longest Idle Time'
     * @return string 'Longest Idle Time'
     */
    const VALUE_LONGEST_IDLE_TIME = 'Longest Idle Time';
    /**
     * Constant for value 'Broadcast'
     * @return string 'Broadcast'
     */
    const VALUE_BROADCAST = 'Broadcast';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TOP_DOWN
     * @uses self::VALUE_CIRCULAR
     * @uses self::VALUE_LONGEST_IDLE_TIME
     * @uses self::VALUE_BROADCAST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TOP_DOWN,
            self::VALUE_CIRCULAR,
            self::VALUE_LONGEST_IDLE_TIME,
            self::VALUE_BROADCAST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
