<?php

namespace CUCM\EnumType;

/**
 * This class stands for XData EnumType
 * @subpackage Enumerations
 */
class XData
{
    /**
     * Constant for value 'SMALLINT'
     * @return string 'SMALLINT'
     */
    const VALUE_SMALLINT = 'SMALLINT';
    /**
     * Constant for value 'INTEGER'
     * @return string 'INTEGER'
     */
    const VALUE_INTEGER = 'INTEGER';
    /**
     * Constant for value 'INT8'
     * @return string 'INT8'
     */
    const VALUE_INT_8 = 'INT8';
    /**
     * Constant for value 'INT'
     * @return string 'INT'
     */
    const VALUE_INT = 'INT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SMALLINT
     * @uses self::VALUE_INTEGER
     * @uses self::VALUE_INT_8
     * @uses self::VALUE_INT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SMALLINT,
            self::VALUE_INTEGER,
            self::VALUE_INT_8,
            self::VALUE_INT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
