<?php

namespace CUCM\EnumType;

/**
 * This class stands for XDPTraceLevel EnumType
 * @subpackage Enumerations
 */
class XDPTraceLevel
{
    /**
     * Constant for value 'Level 0'
     * @return string 'Level 0'
     */
    const VALUE_LEVEL_0 = 'Level 0';
    /**
     * Constant for value 'Level 1'
     * @return string 'Level 1'
     */
    const VALUE_LEVEL_1 = 'Level 1';
    /**
     * Constant for value 'Level 2'
     * @return string 'Level 2'
     */
    const VALUE_LEVEL_2 = 'Level 2';
    /**
     * Constant for value 'Level 3'
     * @return string 'Level 3'
     */
    const VALUE_LEVEL_3 = 'Level 3';
    /**
     * Constant for value 'Custom'
     * @return string 'Custom'
     */
    const VALUE_CUSTOM = 'Custom';
    /**
     * Constant for value 'No Change'
     * @return string 'No Change'
     */
    const VALUE_NO_CHANGE = 'No Change';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LEVEL_0
     * @uses self::VALUE_LEVEL_1
     * @uses self::VALUE_LEVEL_2
     * @uses self::VALUE_LEVEL_3
     * @uses self::VALUE_CUSTOM
     * @uses self::VALUE_NO_CHANGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LEVEL_0,
            self::VALUE_LEVEL_1,
            self::VALUE_LEVEL_2,
            self::VALUE_LEVEL_3,
            self::VALUE_CUSTOM,
            self::VALUE_NO_CHANGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
