<?php

namespace CUCM\EnumType;

/**
 * This class stands for XDPJobFeature EnumType
 * @subpackage Enumerations
 */
class XDPJobFeature
{
    /**
     * Constant for value 'Scheduled Collection'
     * @return string 'Scheduled Collection'
     */
    const VALUE_SCHEDULED_COLLECTION = 'Scheduled Collection';
    /**
     * Constant for value 'Scheduled Trace Modification and Collection'
     * @return string 'Scheduled Trace Modification and Collection'
     */
    const VALUE_SCHEDULED_TRACE_MODIFICATION_AND_COLLECTION = 'Scheduled Trace Modification and Collection';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SCHEDULED_COLLECTION
     * @uses self::VALUE_SCHEDULED_TRACE_MODIFICATION_AND_COLLECTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SCHEDULED_COLLECTION,
            self::VALUE_SCHEDULED_TRACE_MODIFICATION_AND_COLLECTION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
