<?php

namespace CUCM\EnumType;

/**
 * This class stands for XCredentialUser EnumType
 * @subpackage Enumerations
 */
class XCredentialUser
{
    /**
     * Constant for value 'End User'
     * @return string 'End User'
     */
    const VALUE_END_USER = 'End User';
    /**
     * Constant for value 'Application User'
     * @return string 'Application User'
     */
    const VALUE_APPLICATION_USER = 'Application User';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_END_USER
     * @uses self::VALUE_APPLICATION_USER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_END_USER,
            self::VALUE_APPLICATION_USER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
