<?php

namespace CUCM\EnumType;

/**
 * This class stands for XConnectedPBX EnumType
 * @subpackage Enumerations
 */
class XConnectedPBX
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Siemens Hicom'
     * @return string 'Siemens Hicom'
     */
    const VALUE_SIEMENS_HICOM = 'Siemens Hicom';
    /**
     * Constant for value 'Ericsson MD-110'
     * @return string 'Ericsson MD-110'
     */
    const VALUE_ERICSSON_MD_110 = 'Ericsson MD-110';
    /**
     * Constant for value 'Alcatel PBX'
     * @return string 'Alcatel PBX'
     */
    const VALUE_ALCATEL_PBX = 'Alcatel PBX';
    /**
     * Constant for value 'Meridian Option 11C'
     * @return string 'Meridian Option 11C'
     */
    const VALUE_MERIDIAN_OPTION_11_C = 'Meridian Option 11C';
    /**
     * Constant for value 'Lucent Definity G3'
     * @return string 'Lucent Definity G3'
     */
    const VALUE_LUCENT_DEFINITY_G_3 = 'Lucent Definity G3';
    /**
     * Constant for value 'IPC MX'
     * @return string 'IPC MX'
     */
    const VALUE_IPC_MX = 'IPC MX';
    /**
     * Constant for value 'Cisco CCM'
     * @return string 'Cisco CCM'
     */
    const VALUE_CISCO_CCM = 'Cisco CCM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_SIEMENS_HICOM
     * @uses self::VALUE_ERICSSON_MD_110
     * @uses self::VALUE_ALCATEL_PBX
     * @uses self::VALUE_MERIDIAN_OPTION_11_C
     * @uses self::VALUE_LUCENT_DEFINITY_G_3
     * @uses self::VALUE_IPC_MX
     * @uses self::VALUE_CISCO_CCM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_SIEMENS_HICOM,
            self::VALUE_ERICSSON_MD_110,
            self::VALUE_ALCATEL_PBX,
            self::VALUE_MERIDIAN_OPTION_11_C,
            self::VALUE_LUCENT_DEFINITY_G_3,
            self::VALUE_IPC_MX,
            self::VALUE_CISCO_CCM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
