<?php

namespace CUCM\EnumType;

/**
 * This class stands for XConfigInputData EnumType
 * @subpackage Enumerations
 */
class XConfigInputData
{
    /**
     * Constant for value 'Application Dial Rules'
     * @return string 'Application Dial Rules'
     */
    const VALUE_APPLICATION_DIAL_RULES = 'Application Dial Rules';
    /**
     * Constant for value 'Cisco Unified Communications Manager'
     * @return string 'Cisco Unified Communications Manager'
     */
    const VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER = 'Cisco Unified Communications Manager';
    /**
     * Constant for value 'Cisco Unified Communications Manager Group'
     * @return string 'Cisco Unified Communications Manager Group'
     */
    const VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER_GROUP = 'Cisco Unified Communications Manager Group';
    /**
     * Constant for value 'CSS (Class of Control)'
     * @return string 'CSS (Class of Control)'
     */
    const VALUE_CSS_CLASS_OF_CONTROL = 'CSS (Class of Control)';
    /**
     * Constant for value 'Date/Time Group'
     * @return string 'Date/Time Group'
     */
    const VALUE_DATE_TIME_GROUP = 'Date/Time Group';
    /**
     * Constant for value 'Device Pool'
     * @return string 'Device Pool'
     */
    const VALUE_DEVICE_POOL = 'Device Pool';
    /**
     * Constant for value 'Enterprise Parameter'
     * @return string 'Enterprise Parameter'
     */
    const VALUE_ENTERPRISE_PARAMETER = 'Enterprise Parameter';
    /**
     * Constant for value 'Location'
     * @return string 'Location'
     */
    const VALUE_LOCATION = 'Location';
    /**
     * Constant for value 'Partitions (Class of Control)'
     * @return string 'Partitions (Class of Control)'
     */
    const VALUE_PARTITIONS_CLASS_OF_CONTROL = 'Partitions (Class of Control)';
    /**
     * Constant for value 'Phone NTP Reference'
     * @return string 'Phone NTP Reference'
     */
    const VALUE_PHONE_NTP_REFERENCE = 'Phone NTP Reference';
    /**
     * Constant for value 'Region'
     * @return string 'Region'
     */
    const VALUE_REGION = 'Region';
    /**
     * Constant for value 'Route Filter'
     * @return string 'Route Filter'
     */
    const VALUE_ROUTE_FILTER = 'Route Filter';
    /**
     * Constant for value 'Server'
     * @return string 'Server'
     */
    const VALUE_SERVER = 'Server';
    /**
     * Constant for value 'Service Parameter'
     * @return string 'Service Parameter'
     */
    const VALUE_SERVICE_PARAMETER = 'Service Parameter';
    /**
     * Constant for value 'SRST'
     * @return string 'SRST'
     */
    const VALUE_SRST = 'SRST';
    /**
     * Constant for value 'Security Profile (Phone & SIP Trunk)'
     * @return string 'Security Profile (Phone & SIP Trunk)'
     */
    const VALUE_SECURITY_PROFILE_PHONE_SIP_TRUNK = 'Security Profile (Phone & SIP Trunk)';
    /**
     * Constant for value 'Time Period (Class of Control)'
     * @return string 'Time Period (Class of Control)'
     */
    const VALUE_TIME_PERIOD_CLASS_OF_CONTROL = 'Time Period (Class of Control)';
    /**
     * Constant for value 'Time Schedule (Class of Control)'
     * @return string 'Time Schedule (Class of Control)'
     */
    const VALUE_TIME_SCHEDULE_CLASS_OF_CONTROL = 'Time Schedule (Class of Control)';
    /**
     * Constant for value 'Translation Pattern'
     * @return string 'Translation Pattern'
     */
    const VALUE_TRANSLATION_PATTERN = 'Translation Pattern';
    /**
     * Constant for value 'AAR Group'
     * @return string 'AAR Group'
     */
    const VALUE_AAR_GROUP = 'AAR Group';
    /**
     * Constant for value 'Annunciator'
     * @return string 'Annunciator'
     */
    const VALUE_ANNUNCIATOR = 'Annunciator';
    /**
     * Constant for value 'Conference Bridge'
     * @return string 'Conference Bridge'
     */
    const VALUE_CONFERENCE_BRIDGE = 'Conference Bridge';
    /**
     * Constant for value 'Media Resource Group'
     * @return string 'Media Resource Group'
     */
    const VALUE_MEDIA_RESOURCE_GROUP = 'Media Resource Group';
    /**
     * Constant for value 'Media Resource Group List'
     * @return string 'Media Resource Group List'
     */
    const VALUE_MEDIA_RESOURCE_GROUP_LIST = 'Media Resource Group List';
    /**
     * Constant for value 'Media Termination Point'
     * @return string 'Media Termination Point'
     */
    const VALUE_MEDIA_TERMINATION_POINT = 'Media Termination Point';
    /**
     * Constant for value 'Physical Location'
     * @return string 'Physical Location'
     */
    const VALUE_PHYSICAL_LOCATION = 'Physical Location';
    /**
     * Constant for value 'Device Mobility group'
     * @return string 'Device Mobility group'
     */
    const VALUE_DEVICE_MOBILITY_GROUP = 'Device Mobility group';
    /**
     * Constant for value 'Transcoder'
     * @return string 'Transcoder'
     */
    const VALUE_TRANSCODER = 'Transcoder';
    /**
     * Constant for value 'SIP Realm'
     * @return string 'SIP Realm'
     */
    const VALUE_SIP_REALM = 'SIP Realm';
    /**
     * Constant for value 'Application User'
     * @return string 'Application User'
     */
    const VALUE_APPLICATION_USER = 'Application User';
    /**
     * Constant for value 'User Group'
     * @return string 'User Group'
     */
    const VALUE_USER_GROUP = 'User Group';
    /**
     * Constant for value 'Role'
     * @return string 'Role'
     */
    const VALUE_ROLE = 'Role';
    /**
     * Constant for value 'Application User CAPF Profile'
     * @return string 'Application User CAPF Profile'
     */
    const VALUE_APPLICATION_USER_CAPF_PROFILE = 'Application User CAPF Profile';
    /**
     * Constant for value 'Presence Group'
     * @return string 'Presence Group'
     */
    const VALUE_PRESENCE_GROUP = 'Presence Group';
    /**
     * Constant for value 'Credential Policy Default'
     * @return string 'Credential Policy Default'
     */
    const VALUE_CREDENTIAL_POLICY_DEFAULT = 'Credential Policy Default';
    /**
     * Constant for value 'Credential Policy'
     * @return string 'Credential Policy'
     */
    const VALUE_CREDENTIAL_POLICY = 'Credential Policy';
    /**
     * Constant for value 'LDAP System'
     * @return string 'LDAP System'
     */
    const VALUE_LDAP_SYSTEM = 'LDAP System';
    /**
     * Constant for value 'End User'
     * @return string 'End User'
     */
    const VALUE_END_USER = 'End User';
    /**
     * Constant for value 'End User CAPF Profile'
     * @return string 'End User CAPF Profile'
     */
    const VALUE_END_USER_CAPF_PROFILE = 'End User CAPF Profile';
    /**
     * Constant for value 'Softkey Template'
     * @return string 'Softkey Template'
     */
    const VALUE_SOFTKEY_TEMPLATE = 'Softkey Template';
    /**
     * Constant for value 'Gate Keeper'
     * @return string 'Gate Keeper'
     */
    const VALUE_GATE_KEEPER = 'Gate Keeper';
    /**
     * Constant for value 'Trunk'
     * @return string 'Trunk'
     */
    const VALUE_TRUNK = 'Trunk';
    /**
     * Constant for value 'SIP Profile'
     * @return string 'SIP Profile'
     */
    const VALUE_SIP_PROFILE = 'SIP Profile';
    /**
     * Constant for value 'Phone Services'
     * @return string 'Phone Services'
     */
    const VALUE_PHONE_SERVICES = 'Phone Services';
    /**
     * Constant for value 'Forced Authorization Codes'
     * @return string 'Forced Authorization Codes'
     */
    const VALUE_FORCED_AUTHORIZATION_CODES = 'Forced Authorization Codes';
    /**
     * Constant for value 'Phone Button Template'
     * @return string 'Phone Button Template'
     */
    const VALUE_PHONE_BUTTON_TEMPLATE = 'Phone Button Template';
    /**
     * Constant for value 'Directory Lookup Dial Rules'
     * @return string 'Directory Lookup Dial Rules'
     */
    const VALUE_DIRECTORY_LOOKUP_DIAL_RULES = 'Directory Lookup Dial Rules';
    /**
     * Constant for value 'Common Phone Profile'
     * @return string 'Common Phone Profile'
     */
    const VALUE_COMMON_PHONE_PROFILE = 'Common Phone Profile';
    /**
     * Constant for value 'Client Matter Codes'
     * @return string 'Client Matter Codes'
     */
    const VALUE_CLIENT_MATTER_CODES = 'Client Matter Codes';
    /**
     * Constant for value 'Call Park'
     * @return string 'Call Park'
     */
    const VALUE_CALL_PARK = 'Call Park';
    /**
     * Constant for value 'Call Pickup Group'
     * @return string 'Call Pickup Group'
     */
    const VALUE_CALL_PICKUP_GROUP = 'Call Pickup Group';
    /**
     * Constant for value 'Directory Number (Unassigned)'
     * @return string 'Directory Number (Unassigned)'
     */
    const VALUE_DIRECTORY_NUMBER_UNASSIGNED = 'Directory Number (Unassigned)';
    /**
     * Constant for value 'Message Waiting Numbers'
     * @return string 'Message Waiting Numbers'
     */
    const VALUE_MESSAGE_WAITING_NUMBERS = 'Message Waiting Numbers';
    /**
     * Constant for value 'MOH Server'
     * @return string 'MOH Server'
     */
    const VALUE_MOH_SERVER = 'MOH Server';
    /**
     * Constant for value 'Meet-Me Number / Pattern'
     * @return string 'Meet-Me Number / Pattern'
     */
    const VALUE_MEET_ME_NUMBER_PATTERN = 'Meet-Me Number / Pattern';
    /**
     * Constant for value 'Device Mobility Info'
     * @return string 'Device Mobility Info'
     */
    const VALUE_DEVICE_MOBILITY_INFO = 'Device Mobility Info';
    /**
     * Constant for value 'DHCP Server'
     * @return string 'DHCP Server'
     */
    const VALUE_DHCP_SERVER = 'DHCP Server';
    /**
     * Constant for value 'DHCP Subnet'
     * @return string 'DHCP Subnet'
     */
    const VALUE_DHCP_SUBNET = 'DHCP Subnet';
    /**
     * Constant for value 'Gateway'
     * @return string 'Gateway'
     */
    const VALUE_GATEWAY = 'Gateway';
    /**
     * Constant for value 'Voice Mail Pilot'
     * @return string 'Voice Mail Pilot'
     */
    const VALUE_VOICE_MAIL_PILOT = 'Voice Mail Pilot';
    /**
     * Constant for value 'Voice Mail Profile'
     * @return string 'Voice Mail Profile'
     */
    const VALUE_VOICE_MAIL_PROFILE = 'Voice Mail Profile';
    /**
     * Constant for value 'Voice Mail Port'
     * @return string 'Voice Mail Port'
     */
    const VALUE_VOICE_MAIL_PORT = 'Voice Mail Port';
    /**
     * Constant for value 'Device Defaults'
     * @return string 'Device Defaults'
     */
    const VALUE_DEVICE_DEFAULTS = 'Device Defaults';
    /**
     * Constant for value 'Device Profile'
     * @return string 'Device Profile'
     */
    const VALUE_DEVICE_PROFILE = 'Device Profile';
    /**
     * Constant for value 'Common Device Configuration'
     * @return string 'Common Device Configuration'
     */
    const VALUE_COMMON_DEVICE_CONFIGURATION = 'Common Device Configuration';
    /**
     * Constant for value 'CTI Route Point'
     * @return string 'CTI Route Point'
     */
    const VALUE_CTI_ROUTE_POINT = 'CTI Route Point';
    /**
     * Constant for value 'Application Server'
     * @return string 'Application Server'
     */
    const VALUE_APPLICATION_SERVER = 'Application Server';
    /**
     * Constant for value 'Phone'
     * @return string 'Phone'
     */
    const VALUE_PHONE = 'Phone';
    /**
     * Constant for value 'Directed Call Park'
     * @return string 'Directed Call Park'
     */
    const VALUE_DIRECTED_CALL_PARK = 'Directed Call Park';
    /**
     * Constant for value 'SIP Dial Rules'
     * @return string 'SIP Dial Rules'
     */
    const VALUE_SIP_DIAL_RULES = 'SIP Dial Rules';
    /**
     * Constant for value 'LDAP Directory'
     * @return string 'LDAP Directory'
     */
    const VALUE_LDAP_DIRECTORY = 'LDAP Directory';
    /**
     * Constant for value 'LDAP Authentication'
     * @return string 'LDAP Authentication'
     */
    const VALUE_LDAP_AUTHENTICATION = 'LDAP Authentication';
    /**
     * Constant for value 'MLPP Domain'
     * @return string 'MLPP Domain'
     */
    const VALUE_MLPP_DOMAIN = 'MLPP Domain';
    /**
     * Constant for value 'Line Group'
     * @return string 'Line Group'
     */
    const VALUE_LINE_GROUP = 'Line Group';
    /**
     * Constant for value 'Route Group'
     * @return string 'Route Group'
     */
    const VALUE_ROUTE_GROUP = 'Route Group';
    /**
     * Constant for value 'Recording Profile'
     * @return string 'Recording Profile'
     */
    const VALUE_RECORDING_PROFILE = 'Recording Profile';
    /**
     * Constant for value 'Hunt List'
     * @return string 'Hunt List'
     */
    const VALUE_HUNT_LIST = 'Hunt List';
    /**
     * Constant for value 'Route List'
     * @return string 'Route List'
     */
    const VALUE_ROUTE_LIST = 'Route List';
    /**
     * Constant for value 'Hunt Pilot'
     * @return string 'Hunt Pilot'
     */
    const VALUE_HUNT_PILOT = 'Hunt Pilot';
    /**
     * Constant for value 'Remote Destination'
     * @return string 'Remote Destination'
     */
    const VALUE_REMOTE_DESTINATION = 'Remote Destination';
    /**
     * Constant for value 'Intercom Route Partition'
     * @return string 'Intercom Route Partition'
     */
    const VALUE_INTERCOM_ROUTE_PARTITION = 'Intercom Route Partition';
    /**
     * Constant for value 'Intercom CSS'
     * @return string 'Intercom CSS'
     */
    const VALUE_INTERCOM_CSS = 'Intercom CSS';
    /**
     * Constant for value 'Access List'
     * @return string 'Access List'
     */
    const VALUE_ACCESS_LIST = 'Access List';
    /**
     * Constant for value 'Remote Destination Profile'
     * @return string 'Remote Destination Profile'
     */
    const VALUE_REMOTE_DESTINATION_PROFILE = 'Remote Destination Profile';
    /**
     * Constant for value 'Route Pattern'
     * @return string 'Route Pattern'
     */
    const VALUE_ROUTE_PATTERN = 'Route Pattern';
    /**
     * Constant for value 'Called Party Transformation Pattern'
     * @return string 'Called Party Transformation Pattern'
     */
    const VALUE_CALLED_PARTY_TRANSFORMATION_PATTERN = 'Called Party Transformation Pattern';
    /**
     * Constant for value 'SIP Route Pattern'
     * @return string 'SIP Route Pattern'
     */
    const VALUE_SIP_ROUTE_PATTERN = 'SIP Route Pattern';
    /**
     * Constant for value 'Intercom Directory Number (Unassigned)'
     * @return string 'Intercom Directory Number (Unassigned)'
     */
    const VALUE_INTERCOM_DIRECTORY_NUMBER_UNASSIGNED = 'Intercom Directory Number (Unassigned)';
    /**
     * Constant for value 'SlotConfiguration'
     * @return string 'SlotConfiguration'
     */
    const VALUE_SLOT_CONFIGURATION = 'SlotConfiguration';
    /**
     * Constant for value 'PRI'
     * @return string 'PRI'
     */
    const VALUE_PRI = 'PRI';
    /**
     * Constant for value 'BRI'
     * @return string 'BRI'
     */
    const VALUE_BRI = 'BRI';
    /**
     * Constant for value 'T1CAS'
     * @return string 'T1CAS'
     */
    const VALUE_T_1_CAS = 'T1CAS';
    /**
     * Constant for value 'FXS'
     * @return string 'FXS'
     */
    const VALUE_FXS = 'FXS';
    /**
     * Constant for value 'FXO'
     * @return string 'FXO'
     */
    const VALUE_FXO = 'FXO';
    /**
     * Constant for value 'ANALOG'
     * @return string 'ANALOG'
     */
    const VALUE_ANALOG = 'ANALOG';
    /**
     * Constant for value 'H323'
     * @return string 'H323'
     */
    const VALUE_H_323 = 'H323';
    /**
     * Constant for value 'VGC'
     * @return string 'VGC'
     */
    const VALUE_VGC = 'VGC';
    /**
     * Constant for value 'CAT6K'
     * @return string 'CAT6K'
     */
    const VALUE_CAT_6_K = 'CAT6K';
    /**
     * Constant for value 'CAT6K E1 VOIP'
     * @return string 'CAT6K E1 VOIP'
     */
    const VALUE_CAT_6_K_E_1_VOIP = 'CAT6K E1 VOIP';
    /**
     * Constant for value 'CAT6K T1 PRI'
     * @return string 'CAT6K T1 PRI'
     */
    const VALUE_CAT_6_K_T_1_PRI = 'CAT6K T1 PRI';
    /**
     * Constant for value 'Mobile Voice Access'
     * @return string 'Mobile Voice Access'
     */
    const VALUE_MOBILE_VOICE_ACCESS = 'Mobile Voice Access';
    /**
     * Constant for value 'Resource Priority Namespace Network Domain'
     * @return string 'Resource Priority Namespace Network Domain'
     */
    const VALUE_RESOURCE_PRIORITY_NAMESPACE_NETWORK_DOMAIN = 'Resource Priority Namespace Network Domain';
    /**
     * Constant for value 'Intercom Translation Pattern'
     * @return string 'Intercom Translation Pattern'
     */
    const VALUE_INTERCOM_TRANSLATION_PATTERN = 'Intercom Translation Pattern';
    /**
     * Constant for value 'Resource Priority Namespace List'
     * @return string 'Resource Priority Namespace List'
     */
    const VALUE_RESOURCE_PRIORITY_NAMESPACE_LIST = 'Resource Priority Namespace List';
    /**
     * Constant for value 'Calling Party Transformation Pattern'
     * @return string 'Calling Party Transformation Pattern'
     */
    const VALUE_CALLING_PARTY_TRANSFORMATION_PATTERN = 'Calling Party Transformation Pattern';
    /**
     * Constant for value 'CUMA Server Security Profile'
     * @return string 'CUMA Server Security Profile'
     */
    const VALUE_CUMA_SERVER_SECURITY_PROFILE = 'CUMA Server Security Profile';
    /**
     * Constant for value 'CAT6K T1 CAS'
     * @return string 'CAT6K T1 CAS'
     */
    const VALUE_CAT_6_K_T_1_CAS = 'CAT6K T1 CAS';
    /**
     * Constant for value 'Geo Location Configuration'
     * @return string 'Geo Location Configuration'
     */
    const VALUE_GEO_LOCATION_CONFIGURATION = 'Geo Location Configuration';
    /**
     * Constant for value 'Geo Location Filter'
     * @return string 'Geo Location Filter'
     */
    const VALUE_GEO_LOCATION_FILTER = 'Geo Location Filter';
    /**
     * Constant for value 'Logical Partition Policy Configuration'
     * @return string 'Logical Partition Policy Configuration'
     */
    const VALUE_LOGICAL_PARTITION_POLICY_CONFIGURATION = 'Logical Partition Policy Configuration';
    /**
     * Constant for value 'Enterprise Phone Configuration'
     * @return string 'Enterprise Phone Configuration'
     */
    const VALUE_ENTERPRISE_PHONE_CONFIGURATION = 'Enterprise Phone Configuration';
    /**
     * Constant for value 'SAF Forwarder'
     * @return string 'SAF Forwarder'
     */
    const VALUE_SAF_FORWARDER = 'SAF Forwarder';
    /**
     * Constant for value 'CCD Requesting Service'
     * @return string 'CCD Requesting Service'
     */
    const VALUE_CCD_REQUESTING_SERVICE = 'CCD Requesting Service';
    /**
     * Constant for value 'SAF Security Profile'
     * @return string 'SAF Security Profile'
     */
    const VALUE_SAF_SECURITY_PROFILE = 'SAF Security Profile';
    /**
     * Constant for value 'Hosted DN Group'
     * @return string 'Hosted DN Group'
     */
    const VALUE_HOSTED_DN_GROUP = 'Hosted DN Group';
    /**
     * Constant for value 'Block Learned Patterns'
     * @return string 'Block Learned Patterns'
     */
    const VALUE_BLOCK_LEARNED_PATTERNS = 'Block Learned Patterns';
    /**
     * Constant for value 'Hosted DN Patterns'
     * @return string 'Hosted DN Patterns'
     */
    const VALUE_HOSTED_DN_PATTERNS = 'Hosted DN Patterns';
    /**
     * Constant for value 'CCD Advertising Service'
     * @return string 'CCD Advertising Service'
     */
    const VALUE_CCD_ADVERTISING_SERVICE = 'CCD Advertising Service';
    /**
     * Constant for value 'EMCC Remote Cluster'
     * @return string 'EMCC Remote Cluster'
     */
    const VALUE_EMCC_REMOTE_CLUSTER = 'EMCC Remote Cluster';
    /**
     * Constant for value 'EMCC Intercluster Service Profile'
     * @return string 'EMCC Intercluster Service Profile'
     */
    const VALUE_EMCC_INTERCLUSTER_SERVICE_PROFILE = 'EMCC Intercluster Service Profile';
    /**
     * Constant for value 'External Call Control Profile'
     * @return string 'External Call Control Profile'
     */
    const VALUE_EXTERNAL_CALL_CONTROL_PROFILE = 'External Call Control Profile';
    /**
     * Constant for value 'Intercompany Media Engine Server Connections'
     * @return string 'Intercompany Media Engine Server Connections'
     */
    const VALUE_INTERCOMPANY_MEDIA_ENGINE_SERVER_CONNECTIONS = 'Intercompany Media Engine Server Connections';
    /**
     * Constant for value 'Intercompany Media Service'
     * @return string 'Intercompany Media Service'
     */
    const VALUE_INTERCOMPANY_MEDIA_SERVICE = 'Intercompany Media Service';
    /**
     * Constant for value 'Intercompany Media Services Trust Group'
     * @return string 'Intercompany Media Services Trust Group'
     */
    const VALUE_INTERCOMPANY_MEDIA_SERVICES_TRUST_GROUP = 'Intercompany Media Services Trust Group';
    /**
     * Constant for value 'Intercompany Media Services Trust Element'
     * @return string 'Intercompany Media Services Trust Element'
     */
    const VALUE_INTERCOMPANY_MEDIA_SERVICES_TRUST_ELEMENT = 'Intercompany Media Services Trust Element';
    /**
     * Constant for value 'Intercompany Media Services Enrolled Pattern'
     * @return string 'Intercompany Media Services Enrolled Pattern'
     */
    const VALUE_INTERCOMPANY_MEDIA_SERVICES_ENROLLED_PATTERN = 'Intercompany Media Services Enrolled Pattern';
    /**
     * Constant for value 'Intercompany Media Services Enrolled Group'
     * @return string 'Intercompany Media Services Enrolled Group'
     */
    const VALUE_INTERCOMPANY_MEDIA_SERVICES_ENROLLED_GROUP = 'Intercompany Media Services Enrolled Group';
    /**
     * Constant for value 'Intercompany Media Services Exclusion Group'
     * @return string 'Intercompany Media Services Exclusion Group'
     */
    const VALUE_INTERCOMPANY_MEDIA_SERVICES_EXCLUSION_GROUP = 'Intercompany Media Services Exclusion Group';
    /**
     * Constant for value 'Fall Back Profile'
     * @return string 'Fall Back Profile'
     */
    const VALUE_FALL_BACK_PROFILE = 'Fall Back Profile';
    /**
     * Constant for value 'Intercompany Media Services Learned Route'
     * @return string 'Intercompany Media Services Learned Route'
     */
    const VALUE_INTERCOMPANY_MEDIA_SERVICES_LEARNED_ROUTE = 'Intercompany Media Services Learned Route';
    /**
     * Constant for value 'Certificate'
     * @return string 'Certificate'
     */
    const VALUE_CERTIFICATE = 'Certificate';
    /**
     * Constant for value 'VPN Profile'
     * @return string 'VPN Profile'
     */
    const VALUE_VPN_PROFILE = 'VPN Profile';
    /**
     * Constant for value 'VPN Gateway'
     * @return string 'VPN Gateway'
     */
    const VALUE_VPN_GATEWAY = 'VPN Gateway';
    /**
     * Constant for value 'VPN Group'
     * @return string 'VPN Group'
     */
    const VALUE_VPN_GROUP = 'VPN Group';
    /**
     * Constant for value 'Feature Control Policy'
     * @return string 'Feature Control Policy'
     */
    const VALUE_FEATURE_CONTROL_POLICY = 'Feature Control Policy';
    /**
     * Constant for value 'EMCC Feature Config'
     * @return string 'EMCC Feature Config'
     */
    const VALUE_EMCC_FEATURE_CONFIG = 'EMCC Feature Config';
    /**
     * Constant for value 'Intercompany Media Services Firewall'
     * @return string 'Intercompany Media Services Firewall'
     */
    const VALUE_INTERCOMPANY_MEDIA_SERVICES_FIREWALL = 'Intercompany Media Services Firewall';
    /**
     * Constant for value 'LDAP Custom Filter'
     * @return string 'LDAP Custom Filter'
     */
    const VALUE_LDAP_CUSTOM_FILTER = 'LDAP Custom Filter';
    /**
     * Constant for value 'Intercompany Media Services Exclusion Number'
     * @return string 'Intercompany Media Services Exclusion Number'
     */
    const VALUE_INTERCOMPANY_MEDIA_SERVICES_EXCLUSION_NUMBER = 'Intercompany Media Services Exclusion Number';
    /**
     * Constant for value 'Intercompany Media Services E.164 Transformation'
     * @return string 'Intercompany Media Services E.164 Transformation'
     */
    const VALUE_INTERCOMPANY_MEDIA_SERVICES_E_164_TRANSFORMATION = 'Intercompany Media Services E.164 Transformation';
    /**
     * Constant for value 'Intercompany Media Services Feature Configuration'
     * @return string 'Intercompany Media Services Feature Configuration'
     */
    const VALUE_INTERCOMPANY_MEDIA_SERVICES_FEATURE_CONFIGURATION = 'Intercompany Media Services Feature Configuration';
    /**
     * Constant for value 'Fallback Feature Configuraion'
     * @return string 'Fallback Feature Configuraion'
     */
    const VALUE_FALLBACK_FEATURE_CONFIGURAION = 'Fallback Feature Configuraion';
    /**
     * Constant for value 'Transformation Profile'
     * @return string 'Transformation Profile'
     */
    const VALUE_TRANSFORMATION_PROFILE = 'Transformation Profile';
    /**
     * Constant for value 'VPN Feature Configuration'
     * @return string 'VPN Feature Configuration'
     */
    const VALUE_VPN_FEATURE_CONFIGURATION = 'VPN Feature Configuration';
    /**
     * Constant for value 'CCD Feature Configuration'
     * @return string 'CCD Feature Configuration'
     */
    const VALUE_CCD_FEATURE_CONFIGURATION = 'CCD Feature Configuration';
    /**
     * Constant for value 'CCD Partition'
     * @return string 'CCD Partition'
     */
    const VALUE_CCD_PARTITION = 'CCD Partition';
    /**
     * Constant for value 'Default Device Profile'
     * @return string 'Default Device Profile'
     */
    const VALUE_DEFAULT_DEVICE_PROFILE = 'Default Device Profile';
    /**
     * Constant for value 'IPMA Configuration'
     * @return string 'IPMA Configuration'
     */
    const VALUE_IPMA_CONFIGURATION = 'IPMA Configuration';
    /**
     * Constant for value 'Mobility Profile'
     * @return string 'Mobility Profile'
     */
    const VALUE_MOBILITY_PROFILE = 'Mobility Profile';
    /**
     * Constant for value 'Handoff Configuration'
     * @return string 'Handoff Configuration'
     */
    const VALUE_HANDOFF_CONFIGURATION = 'Handoff Configuration';
    /**
     * Constant for value 'Enterprise Feature Access Configuration'
     * @return string 'Enterprise Feature Access Configuration'
     */
    const VALUE_ENTERPRISE_FEATURE_ACCESS_CONFIGURATION = 'Enterprise Feature Access Configuration';
    /**
     * Constant for value 'SIP Normalization Script'
     * @return string 'SIP Normalization Script'
     */
    const VALUE_SIP_NORMALIZATION_SCRIPT = 'SIP Normalization Script';
    /**
     * Constant for value 'Called Party Tracing'
     * @return string 'Called Party Tracing'
     */
    const VALUE_CALLED_PARTY_TRACING = 'Called Party Tracing';
    /**
     * Constant for value 'E1 R2'
     * @return string 'E1 R2'
     */
    const VALUE_E_1_R_2 = 'E1 R2';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_APPLICATION_DIAL_RULES
     * @uses self::VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER
     * @uses self::VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER_GROUP
     * @uses self::VALUE_CSS_CLASS_OF_CONTROL
     * @uses self::VALUE_DATE_TIME_GROUP
     * @uses self::VALUE_DEVICE_POOL
     * @uses self::VALUE_ENTERPRISE_PARAMETER
     * @uses self::VALUE_LOCATION
     * @uses self::VALUE_PARTITIONS_CLASS_OF_CONTROL
     * @uses self::VALUE_PHONE_NTP_REFERENCE
     * @uses self::VALUE_REGION
     * @uses self::VALUE_ROUTE_FILTER
     * @uses self::VALUE_SERVER
     * @uses self::VALUE_SERVICE_PARAMETER
     * @uses self::VALUE_SRST
     * @uses self::VALUE_SECURITY_PROFILE_PHONE_SIP_TRUNK
     * @uses self::VALUE_TIME_PERIOD_CLASS_OF_CONTROL
     * @uses self::VALUE_TIME_SCHEDULE_CLASS_OF_CONTROL
     * @uses self::VALUE_TRANSLATION_PATTERN
     * @uses self::VALUE_AAR_GROUP
     * @uses self::VALUE_ANNUNCIATOR
     * @uses self::VALUE_CONFERENCE_BRIDGE
     * @uses self::VALUE_MEDIA_RESOURCE_GROUP
     * @uses self::VALUE_MEDIA_RESOURCE_GROUP_LIST
     * @uses self::VALUE_MEDIA_TERMINATION_POINT
     * @uses self::VALUE_PHYSICAL_LOCATION
     * @uses self::VALUE_DEVICE_MOBILITY_GROUP
     * @uses self::VALUE_TRANSCODER
     * @uses self::VALUE_SIP_REALM
     * @uses self::VALUE_APPLICATION_USER
     * @uses self::VALUE_USER_GROUP
     * @uses self::VALUE_ROLE
     * @uses self::VALUE_APPLICATION_USER_CAPF_PROFILE
     * @uses self::VALUE_PRESENCE_GROUP
     * @uses self::VALUE_CREDENTIAL_POLICY_DEFAULT
     * @uses self::VALUE_CREDENTIAL_POLICY
     * @uses self::VALUE_LDAP_SYSTEM
     * @uses self::VALUE_END_USER
     * @uses self::VALUE_END_USER_CAPF_PROFILE
     * @uses self::VALUE_SOFTKEY_TEMPLATE
     * @uses self::VALUE_GATE_KEEPER
     * @uses self::VALUE_TRUNK
     * @uses self::VALUE_SIP_PROFILE
     * @uses self::VALUE_PHONE_SERVICES
     * @uses self::VALUE_FORCED_AUTHORIZATION_CODES
     * @uses self::VALUE_PHONE_BUTTON_TEMPLATE
     * @uses self::VALUE_DIRECTORY_LOOKUP_DIAL_RULES
     * @uses self::VALUE_COMMON_PHONE_PROFILE
     * @uses self::VALUE_CLIENT_MATTER_CODES
     * @uses self::VALUE_CALL_PARK
     * @uses self::VALUE_CALL_PICKUP_GROUP
     * @uses self::VALUE_DIRECTORY_NUMBER_UNASSIGNED
     * @uses self::VALUE_MESSAGE_WAITING_NUMBERS
     * @uses self::VALUE_MOH_SERVER
     * @uses self::VALUE_MEET_ME_NUMBER_PATTERN
     * @uses self::VALUE_DEVICE_MOBILITY_INFO
     * @uses self::VALUE_DHCP_SERVER
     * @uses self::VALUE_DHCP_SUBNET
     * @uses self::VALUE_GATEWAY
     * @uses self::VALUE_VOICE_MAIL_PILOT
     * @uses self::VALUE_VOICE_MAIL_PROFILE
     * @uses self::VALUE_VOICE_MAIL_PORT
     * @uses self::VALUE_DEVICE_DEFAULTS
     * @uses self::VALUE_DEVICE_PROFILE
     * @uses self::VALUE_COMMON_DEVICE_CONFIGURATION
     * @uses self::VALUE_CTI_ROUTE_POINT
     * @uses self::VALUE_APPLICATION_SERVER
     * @uses self::VALUE_PHONE
     * @uses self::VALUE_DIRECTED_CALL_PARK
     * @uses self::VALUE_SIP_DIAL_RULES
     * @uses self::VALUE_LDAP_DIRECTORY
     * @uses self::VALUE_LDAP_AUTHENTICATION
     * @uses self::VALUE_MLPP_DOMAIN
     * @uses self::VALUE_LINE_GROUP
     * @uses self::VALUE_ROUTE_GROUP
     * @uses self::VALUE_RECORDING_PROFILE
     * @uses self::VALUE_HUNT_LIST
     * @uses self::VALUE_ROUTE_LIST
     * @uses self::VALUE_HUNT_PILOT
     * @uses self::VALUE_REMOTE_DESTINATION
     * @uses self::VALUE_INTERCOM_ROUTE_PARTITION
     * @uses self::VALUE_INTERCOM_CSS
     * @uses self::VALUE_ACCESS_LIST
     * @uses self::VALUE_REMOTE_DESTINATION_PROFILE
     * @uses self::VALUE_ROUTE_PATTERN
     * @uses self::VALUE_CALLED_PARTY_TRANSFORMATION_PATTERN
     * @uses self::VALUE_SIP_ROUTE_PATTERN
     * @uses self::VALUE_INTERCOM_DIRECTORY_NUMBER_UNASSIGNED
     * @uses self::VALUE_SLOT_CONFIGURATION
     * @uses self::VALUE_PRI
     * @uses self::VALUE_BRI
     * @uses self::VALUE_T_1_CAS
     * @uses self::VALUE_FXS
     * @uses self::VALUE_FXO
     * @uses self::VALUE_ANALOG
     * @uses self::VALUE_H_323
     * @uses self::VALUE_VGC
     * @uses self::VALUE_CAT_6_K
     * @uses self::VALUE_CAT_6_K_E_1_VOIP
     * @uses self::VALUE_CAT_6_K_T_1_PRI
     * @uses self::VALUE_MOBILE_VOICE_ACCESS
     * @uses self::VALUE_RESOURCE_PRIORITY_NAMESPACE_NETWORK_DOMAIN
     * @uses self::VALUE_INTERCOM_TRANSLATION_PATTERN
     * @uses self::VALUE_RESOURCE_PRIORITY_NAMESPACE_LIST
     * @uses self::VALUE_CALLING_PARTY_TRANSFORMATION_PATTERN
     * @uses self::VALUE_CUMA_SERVER_SECURITY_PROFILE
     * @uses self::VALUE_CAT_6_K_T_1_CAS
     * @uses self::VALUE_GEO_LOCATION_CONFIGURATION
     * @uses self::VALUE_GEO_LOCATION_FILTER
     * @uses self::VALUE_LOGICAL_PARTITION_POLICY_CONFIGURATION
     * @uses self::VALUE_ENTERPRISE_PHONE_CONFIGURATION
     * @uses self::VALUE_SAF_FORWARDER
     * @uses self::VALUE_CCD_REQUESTING_SERVICE
     * @uses self::VALUE_SAF_SECURITY_PROFILE
     * @uses self::VALUE_HOSTED_DN_GROUP
     * @uses self::VALUE_BLOCK_LEARNED_PATTERNS
     * @uses self::VALUE_HOSTED_DN_PATTERNS
     * @uses self::VALUE_CCD_ADVERTISING_SERVICE
     * @uses self::VALUE_EMCC_REMOTE_CLUSTER
     * @uses self::VALUE_EMCC_INTERCLUSTER_SERVICE_PROFILE
     * @uses self::VALUE_EXTERNAL_CALL_CONTROL_PROFILE
     * @uses self::VALUE_INTERCOMPANY_MEDIA_ENGINE_SERVER_CONNECTIONS
     * @uses self::VALUE_INTERCOMPANY_MEDIA_SERVICE
     * @uses self::VALUE_INTERCOMPANY_MEDIA_SERVICES_TRUST_GROUP
     * @uses self::VALUE_INTERCOMPANY_MEDIA_SERVICES_TRUST_ELEMENT
     * @uses self::VALUE_INTERCOMPANY_MEDIA_SERVICES_ENROLLED_PATTERN
     * @uses self::VALUE_INTERCOMPANY_MEDIA_SERVICES_ENROLLED_GROUP
     * @uses self::VALUE_INTERCOMPANY_MEDIA_SERVICES_EXCLUSION_GROUP
     * @uses self::VALUE_FALL_BACK_PROFILE
     * @uses self::VALUE_INTERCOMPANY_MEDIA_SERVICES_LEARNED_ROUTE
     * @uses self::VALUE_CERTIFICATE
     * @uses self::VALUE_VPN_PROFILE
     * @uses self::VALUE_VPN_GATEWAY
     * @uses self::VALUE_VPN_GROUP
     * @uses self::VALUE_FEATURE_CONTROL_POLICY
     * @uses self::VALUE_EMCC_FEATURE_CONFIG
     * @uses self::VALUE_INTERCOMPANY_MEDIA_SERVICES_FIREWALL
     * @uses self::VALUE_LDAP_CUSTOM_FILTER
     * @uses self::VALUE_INTERCOMPANY_MEDIA_SERVICES_EXCLUSION_NUMBER
     * @uses self::VALUE_INTERCOMPANY_MEDIA_SERVICES_E_164_TRANSFORMATION
     * @uses self::VALUE_INTERCOMPANY_MEDIA_SERVICES_FEATURE_CONFIGURATION
     * @uses self::VALUE_FALLBACK_FEATURE_CONFIGURAION
     * @uses self::VALUE_TRANSFORMATION_PROFILE
     * @uses self::VALUE_VPN_FEATURE_CONFIGURATION
     * @uses self::VALUE_CCD_FEATURE_CONFIGURATION
     * @uses self::VALUE_CCD_PARTITION
     * @uses self::VALUE_DEFAULT_DEVICE_PROFILE
     * @uses self::VALUE_IPMA_CONFIGURATION
     * @uses self::VALUE_MOBILITY_PROFILE
     * @uses self::VALUE_HANDOFF_CONFIGURATION
     * @uses self::VALUE_ENTERPRISE_FEATURE_ACCESS_CONFIGURATION
     * @uses self::VALUE_SIP_NORMALIZATION_SCRIPT
     * @uses self::VALUE_CALLED_PARTY_TRACING
     * @uses self::VALUE_E_1_R_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APPLICATION_DIAL_RULES,
            self::VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER,
            self::VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER_GROUP,
            self::VALUE_CSS_CLASS_OF_CONTROL,
            self::VALUE_DATE_TIME_GROUP,
            self::VALUE_DEVICE_POOL,
            self::VALUE_ENTERPRISE_PARAMETER,
            self::VALUE_LOCATION,
            self::VALUE_PARTITIONS_CLASS_OF_CONTROL,
            self::VALUE_PHONE_NTP_REFERENCE,
            self::VALUE_REGION,
            self::VALUE_ROUTE_FILTER,
            self::VALUE_SERVER,
            self::VALUE_SERVICE_PARAMETER,
            self::VALUE_SRST,
            self::VALUE_SECURITY_PROFILE_PHONE_SIP_TRUNK,
            self::VALUE_TIME_PERIOD_CLASS_OF_CONTROL,
            self::VALUE_TIME_SCHEDULE_CLASS_OF_CONTROL,
            self::VALUE_TRANSLATION_PATTERN,
            self::VALUE_AAR_GROUP,
            self::VALUE_ANNUNCIATOR,
            self::VALUE_CONFERENCE_BRIDGE,
            self::VALUE_MEDIA_RESOURCE_GROUP,
            self::VALUE_MEDIA_RESOURCE_GROUP_LIST,
            self::VALUE_MEDIA_TERMINATION_POINT,
            self::VALUE_PHYSICAL_LOCATION,
            self::VALUE_DEVICE_MOBILITY_GROUP,
            self::VALUE_TRANSCODER,
            self::VALUE_SIP_REALM,
            self::VALUE_APPLICATION_USER,
            self::VALUE_USER_GROUP,
            self::VALUE_ROLE,
            self::VALUE_APPLICATION_USER_CAPF_PROFILE,
            self::VALUE_PRESENCE_GROUP,
            self::VALUE_CREDENTIAL_POLICY_DEFAULT,
            self::VALUE_CREDENTIAL_POLICY,
            self::VALUE_LDAP_SYSTEM,
            self::VALUE_END_USER,
            self::VALUE_END_USER_CAPF_PROFILE,
            self::VALUE_SOFTKEY_TEMPLATE,
            self::VALUE_GATE_KEEPER,
            self::VALUE_TRUNK,
            self::VALUE_SIP_PROFILE,
            self::VALUE_PHONE_SERVICES,
            self::VALUE_FORCED_AUTHORIZATION_CODES,
            self::VALUE_PHONE_BUTTON_TEMPLATE,
            self::VALUE_DIRECTORY_LOOKUP_DIAL_RULES,
            self::VALUE_COMMON_PHONE_PROFILE,
            self::VALUE_CLIENT_MATTER_CODES,
            self::VALUE_CALL_PARK,
            self::VALUE_CALL_PICKUP_GROUP,
            self::VALUE_DIRECTORY_NUMBER_UNASSIGNED,
            self::VALUE_MESSAGE_WAITING_NUMBERS,
            self::VALUE_MOH_SERVER,
            self::VALUE_MEET_ME_NUMBER_PATTERN,
            self::VALUE_DEVICE_MOBILITY_INFO,
            self::VALUE_DHCP_SERVER,
            self::VALUE_DHCP_SUBNET,
            self::VALUE_GATEWAY,
            self::VALUE_VOICE_MAIL_PILOT,
            self::VALUE_VOICE_MAIL_PROFILE,
            self::VALUE_VOICE_MAIL_PORT,
            self::VALUE_DEVICE_DEFAULTS,
            self::VALUE_DEVICE_PROFILE,
            self::VALUE_COMMON_DEVICE_CONFIGURATION,
            self::VALUE_CTI_ROUTE_POINT,
            self::VALUE_APPLICATION_SERVER,
            self::VALUE_PHONE,
            self::VALUE_DIRECTED_CALL_PARK,
            self::VALUE_SIP_DIAL_RULES,
            self::VALUE_LDAP_DIRECTORY,
            self::VALUE_LDAP_AUTHENTICATION,
            self::VALUE_MLPP_DOMAIN,
            self::VALUE_LINE_GROUP,
            self::VALUE_ROUTE_GROUP,
            self::VALUE_RECORDING_PROFILE,
            self::VALUE_HUNT_LIST,
            self::VALUE_ROUTE_LIST,
            self::VALUE_HUNT_PILOT,
            self::VALUE_REMOTE_DESTINATION,
            self::VALUE_INTERCOM_ROUTE_PARTITION,
            self::VALUE_INTERCOM_CSS,
            self::VALUE_ACCESS_LIST,
            self::VALUE_REMOTE_DESTINATION_PROFILE,
            self::VALUE_ROUTE_PATTERN,
            self::VALUE_CALLED_PARTY_TRANSFORMATION_PATTERN,
            self::VALUE_SIP_ROUTE_PATTERN,
            self::VALUE_INTERCOM_DIRECTORY_NUMBER_UNASSIGNED,
            self::VALUE_SLOT_CONFIGURATION,
            self::VALUE_PRI,
            self::VALUE_BRI,
            self::VALUE_T_1_CAS,
            self::VALUE_FXS,
            self::VALUE_FXO,
            self::VALUE_ANALOG,
            self::VALUE_H_323,
            self::VALUE_VGC,
            self::VALUE_CAT_6_K,
            self::VALUE_CAT_6_K_E_1_VOIP,
            self::VALUE_CAT_6_K_T_1_PRI,
            self::VALUE_MOBILE_VOICE_ACCESS,
            self::VALUE_RESOURCE_PRIORITY_NAMESPACE_NETWORK_DOMAIN,
            self::VALUE_INTERCOM_TRANSLATION_PATTERN,
            self::VALUE_RESOURCE_PRIORITY_NAMESPACE_LIST,
            self::VALUE_CALLING_PARTY_TRANSFORMATION_PATTERN,
            self::VALUE_CUMA_SERVER_SECURITY_PROFILE,
            self::VALUE_CAT_6_K_T_1_CAS,
            self::VALUE_GEO_LOCATION_CONFIGURATION,
            self::VALUE_GEO_LOCATION_FILTER,
            self::VALUE_LOGICAL_PARTITION_POLICY_CONFIGURATION,
            self::VALUE_ENTERPRISE_PHONE_CONFIGURATION,
            self::VALUE_SAF_FORWARDER,
            self::VALUE_CCD_REQUESTING_SERVICE,
            self::VALUE_SAF_SECURITY_PROFILE,
            self::VALUE_HOSTED_DN_GROUP,
            self::VALUE_BLOCK_LEARNED_PATTERNS,
            self::VALUE_HOSTED_DN_PATTERNS,
            self::VALUE_CCD_ADVERTISING_SERVICE,
            self::VALUE_EMCC_REMOTE_CLUSTER,
            self::VALUE_EMCC_INTERCLUSTER_SERVICE_PROFILE,
            self::VALUE_EXTERNAL_CALL_CONTROL_PROFILE,
            self::VALUE_INTERCOMPANY_MEDIA_ENGINE_SERVER_CONNECTIONS,
            self::VALUE_INTERCOMPANY_MEDIA_SERVICE,
            self::VALUE_INTERCOMPANY_MEDIA_SERVICES_TRUST_GROUP,
            self::VALUE_INTERCOMPANY_MEDIA_SERVICES_TRUST_ELEMENT,
            self::VALUE_INTERCOMPANY_MEDIA_SERVICES_ENROLLED_PATTERN,
            self::VALUE_INTERCOMPANY_MEDIA_SERVICES_ENROLLED_GROUP,
            self::VALUE_INTERCOMPANY_MEDIA_SERVICES_EXCLUSION_GROUP,
            self::VALUE_FALL_BACK_PROFILE,
            self::VALUE_INTERCOMPANY_MEDIA_SERVICES_LEARNED_ROUTE,
            self::VALUE_CERTIFICATE,
            self::VALUE_VPN_PROFILE,
            self::VALUE_VPN_GATEWAY,
            self::VALUE_VPN_GROUP,
            self::VALUE_FEATURE_CONTROL_POLICY,
            self::VALUE_EMCC_FEATURE_CONFIG,
            self::VALUE_INTERCOMPANY_MEDIA_SERVICES_FIREWALL,
            self::VALUE_LDAP_CUSTOM_FILTER,
            self::VALUE_INTERCOMPANY_MEDIA_SERVICES_EXCLUSION_NUMBER,
            self::VALUE_INTERCOMPANY_MEDIA_SERVICES_E_164_TRANSFORMATION,
            self::VALUE_INTERCOMPANY_MEDIA_SERVICES_FEATURE_CONFIGURATION,
            self::VALUE_FALLBACK_FEATURE_CONFIGURAION,
            self::VALUE_TRANSFORMATION_PROFILE,
            self::VALUE_VPN_FEATURE_CONFIGURATION,
            self::VALUE_CCD_FEATURE_CONFIGURATION,
            self::VALUE_CCD_PARTITION,
            self::VALUE_DEFAULT_DEVICE_PROFILE,
            self::VALUE_IPMA_CONFIGURATION,
            self::VALUE_MOBILITY_PROFILE,
            self::VALUE_HANDOFF_CONFIGURATION,
            self::VALUE_ENTERPRISE_FEATURE_ACCESS_CONFIGURATION,
            self::VALUE_SIP_NORMALIZATION_SCRIPT,
            self::VALUE_CALLED_PARTY_TRACING,
            self::VALUE_E_1_R_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
