<?php

namespace CUCM\EnumType;

/**
 * This class stands for XCallTreatmentOnFailure EnumType
 * @subpackage Enumerations
 */
class XCallTreatmentOnFailure
{
    /**
     * Constant for value 'Allow Calls'
     * @return string 'Allow Calls'
     */
    const VALUE_ALLOW_CALLS = 'Allow Calls';
    /**
     * Constant for value 'Block Calls'
     * @return string 'Block Calls'
     */
    const VALUE_BLOCK_CALLS = 'Block Calls';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALLOW_CALLS
     * @uses self::VALUE_BLOCK_CALLS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALLOW_CALLS,
            self::VALUE_BLOCK_CALLS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
