<?php

namespace CUCM\EnumType;

/**
 * This class stands for XCOSRouting EnumType
 * @subpackage Enumerations
 */
class XCOSRouting
{
    /**
     * Constant for value 'Emergency Calls'
     * @return string 'Emergency Calls'
     */
    const VALUE_EMERGENCY_CALLS = 'Emergency Calls';
    /**
     * Constant for value 'Internal Calls'
     * @return string 'Internal Calls'
     */
    const VALUE_INTERNAL_CALLS = 'Internal Calls';
    /**
     * Constant for value 'Inter Cluster Calls'
     * @return string 'Inter Cluster Calls'
     */
    const VALUE_INTER_CLUSTER_CALLS = 'Inter Cluster Calls';
    /**
     * Constant for value 'Local Calls'
     * @return string 'Local Calls'
     */
    const VALUE_LOCAL_CALLS = 'Local Calls';
    /**
     * Constant for value 'Toll Free Calls'
     * @return string 'Toll Free Calls'
     */
    const VALUE_TOLL_FREE_CALLS = 'Toll Free Calls';
    /**
     * Constant for value 'Long Distance Calls'
     * @return string 'Long Distance Calls'
     */
    const VALUE_LONG_DISTANCE_CALLS = 'Long Distance Calls';
    /**
     * Constant for value 'International Calls'
     * @return string 'International Calls'
     */
    const VALUE_INTERNATIONAL_CALLS = 'International Calls';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EMERGENCY_CALLS
     * @uses self::VALUE_INTERNAL_CALLS
     * @uses self::VALUE_INTER_CLUSTER_CALLS
     * @uses self::VALUE_LOCAL_CALLS
     * @uses self::VALUE_TOLL_FREE_CALLS
     * @uses self::VALUE_LONG_DISTANCE_CALLS
     * @uses self::VALUE_INTERNATIONAL_CALLS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EMERGENCY_CALLS,
            self::VALUE_INTERNAL_CALLS,
            self::VALUE_INTER_CLUSTER_CALLS,
            self::VALUE_LOCAL_CALLS,
            self::VALUE_TOLL_FREE_CALLS,
            self::VALUE_LONG_DISTANCE_CALLS,
            self::VALUE_INTERNATIONAL_CALLS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
