<?php

namespace CUCM\EnumType;

/**
 * This class stands for XCFACSSActivationPolicy EnumType
 * @subpackage Enumerations
 */
class XCFACSSActivationPolicy
{
    /**
     * Constant for value 'Use System Default'
     * @return string 'Use System Default'
     */
    const VALUE_USE_SYSTEM_DEFAULT = 'Use System Default';
    /**
     * Constant for value 'With Configured CSS'
     * @return string 'With Configured CSS'
     */
    const VALUE_WITH_CONFIGURED_CSS = 'With Configured CSS';
    /**
     * Constant for value 'With Activating Device/Line CSS'
     * @return string 'With Activating Device/Line CSS'
     */
    const VALUE_WITH_ACTIVATING_DEVICE_LINE_CSS = 'With Activating Device/Line CSS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USE_SYSTEM_DEFAULT
     * @uses self::VALUE_WITH_CONFIGURED_CSS
     * @uses self::VALUE_WITH_ACTIVATING_DEVICE_LINE_CSS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USE_SYSTEM_DEFAULT,
            self::VALUE_WITH_CONFIGURED_CSS,
            self::VALUE_WITH_ACTIVATING_DEVICE_LINE_CSS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
