<?php

namespace CUCM\EnumType;

/**
 * This class stands for XBarge EnumType
 * @subpackage Enumerations
 */
class XBarge
{
    /**
     * Constant for value 'Off'
     * @return string 'Off'
     */
    const VALUE_OFF = 'Off';
    /**
     * Constant for value 'Barge'
     * @return string 'Barge'
     */
    const VALUE_BARGE = 'Barge';
    /**
     * Constant for value 'CBarge'
     * @return string 'CBarge'
     */
    const VALUE_CBARGE = 'CBarge';
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OFF
     * @uses self::VALUE_BARGE
     * @uses self::VALUE_CBARGE
     * @uses self::VALUE_DEFAULT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OFF,
            self::VALUE_BARGE,
            self::VALUE_CBARGE,
            self::VALUE_DEFAULT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
