<?php

namespace CUCM\EnumType;

/**
 * This class stands for XBLFSDOption EnumType
 * @subpackage Enumerations
 */
class XBLFSDOption
{
    /**
     * Constant for value 'Pickup'
     * @return string 'Pickup'
     */
    const VALUE_PICKUP = 'Pickup';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PICKUP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PICKUP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
