<?php

namespace CUCM\EnumType;

/**
 * This class stands for XBATTarget EnumType
 * @subpackage Enumerations
 */
class XBATTarget
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Phones'
     * @return string 'Phones'
     */
    const VALUE_PHONES = 'Phones';
    /**
     * Constant for value 'Users'
     * @return string 'Users'
     */
    const VALUE_USERS = 'Users';
    /**
     * Constant for value 'UDP'
     * @return string 'UDP'
     */
    const VALUE_UDP = 'UDP';
    /**
     * Constant for value 'Gateways'
     * @return string 'Gateways'
     */
    const VALUE_GATEWAYS = 'Gateways';
    /**
     * Constant for value 'CAT6k FXS Ports'
     * @return string 'CAT6k FXS Ports'
     */
    const VALUE_CAT_6_K_FXS_PORTS = 'CAT6k FXS Ports';
    /**
     * Constant for value 'Lines'
     * @return string 'Lines'
     */
    const VALUE_LINES = 'Lines';
    /**
     * Constant for value 'Pickup Groups'
     * @return string 'Pickup Groups'
     */
    const VALUE_PICKUP_GROUPS = 'Pickup Groups';
    /**
     * Constant for value 'Forced Authorization Codes'
     * @return string 'Forced Authorization Codes'
     */
    const VALUE_FORCED_AUTHORIZATION_CODES = 'Forced Authorization Codes';
    /**
     * Constant for value 'Client Matter Codes'
     * @return string 'Client Matter Codes'
     */
    const VALUE_CLIENT_MATTER_CODES = 'Client Matter Codes';
    /**
     * Constant for value 'CAPF'
     * @return string 'CAPF'
     */
    const VALUE_CAPF = 'CAPF';
    /**
     * Constant for value 'Phones/users'
     * @return string 'Phones/users'
     */
    const VALUE_PHONES_USERS = 'Phones/users';
    /**
     * Constant for value 'Managers'
     * @return string 'Managers'
     */
    const VALUE_MANAGERS = 'Managers';
    /**
     * Constant for value 'Assistants'
     * @return string 'Assistants'
     */
    const VALUE_ASSISTANTS = 'Assistants';
    /**
     * Constant for value 'Managers Assistants'
     * @return string 'Managers Assistants'
     */
    const VALUE_MANAGERS_ASSISTANTS = 'Managers Assistants';
    /**
     * Constant for value 'Import/Export'
     * @return string 'Import/Export'
     */
    const VALUE_IMPORT_EXPORT = 'Import/Export';
    /**
     * Constant for value 'CUP Users'
     * @return string 'CUP Users'
     */
    const VALUE_CUP_USERS = 'CUP Users';
    /**
     * Constant for value 'User Line Appearance'
     * @return string 'User Line Appearance'
     */
    const VALUE_USER_LINE_APPEARANCE = 'User Line Appearance';
    /**
     * Constant for value 'Access Lists'
     * @return string 'Access Lists'
     */
    const VALUE_ACCESS_LISTS = 'Access Lists';
    /**
     * Constant for value 'Remote Destination Profiles'
     * @return string 'Remote Destination Profiles'
     */
    const VALUE_REMOTE_DESTINATION_PROFILES = 'Remote Destination Profiles';
    /**
     * Constant for value 'Remote Destination'
     * @return string 'Remote Destination'
     */
    const VALUE_REMOTE_DESTINATION = 'Remote Destination';
    /**
     * Constant for value 'Intercompany Media Services'
     * @return string 'Intercompany Media Services'
     */
    const VALUE_INTERCOMPANY_MEDIA_SERVICES = 'Intercompany Media Services';
    /**
     * Constant for value 'Mobility Profile'
     * @return string 'Mobility Profile'
     */
    const VALUE_MOBILITY_PROFILE = 'Mobility Profile';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_PHONES
     * @uses self::VALUE_USERS
     * @uses self::VALUE_UDP
     * @uses self::VALUE_GATEWAYS
     * @uses self::VALUE_CAT_6_K_FXS_PORTS
     * @uses self::VALUE_LINES
     * @uses self::VALUE_PICKUP_GROUPS
     * @uses self::VALUE_FORCED_AUTHORIZATION_CODES
     * @uses self::VALUE_CLIENT_MATTER_CODES
     * @uses self::VALUE_CAPF
     * @uses self::VALUE_PHONES_USERS
     * @uses self::VALUE_MANAGERS
     * @uses self::VALUE_ASSISTANTS
     * @uses self::VALUE_MANAGERS_ASSISTANTS
     * @uses self::VALUE_IMPORT_EXPORT
     * @uses self::VALUE_CUP_USERS
     * @uses self::VALUE_USER_LINE_APPEARANCE
     * @uses self::VALUE_ACCESS_LISTS
     * @uses self::VALUE_REMOTE_DESTINATION_PROFILES
     * @uses self::VALUE_REMOTE_DESTINATION
     * @uses self::VALUE_INTERCOMPANY_MEDIA_SERVICES
     * @uses self::VALUE_MOBILITY_PROFILE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_PHONES,
            self::VALUE_USERS,
            self::VALUE_UDP,
            self::VALUE_GATEWAYS,
            self::VALUE_CAT_6_K_FXS_PORTS,
            self::VALUE_LINES,
            self::VALUE_PICKUP_GROUPS,
            self::VALUE_FORCED_AUTHORIZATION_CODES,
            self::VALUE_CLIENT_MATTER_CODES,
            self::VALUE_CAPF,
            self::VALUE_PHONES_USERS,
            self::VALUE_MANAGERS,
            self::VALUE_ASSISTANTS,
            self::VALUE_MANAGERS_ASSISTANTS,
            self::VALUE_IMPORT_EXPORT,
            self::VALUE_CUP_USERS,
            self::VALUE_USER_LINE_APPEARANCE,
            self::VALUE_ACCESS_LISTS,
            self::VALUE_REMOTE_DESTINATION_PROFILES,
            self::VALUE_REMOTE_DESTINATION,
            self::VALUE_INTERCOMPANY_MEDIA_SERVICES,
            self::VALUE_MOBILITY_PROFILE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
