<?php

namespace CUCM\EnumType;

/**
 * This class stands for XBATFunction EnumType
 * @subpackage Enumerations
 */
class XBATFunction
{
    /**
     * Constant for value 'Insert Phones - All Details'
     * @return string 'Insert Phones - All Details'
     */
    const VALUE_INSERT_PHONES_ALL_DETAILS = 'Insert Phones - All Details';
    /**
     * Constant for value 'Insert Phones - Specific Details'
     * @return string 'Insert Phones - Specific Details'
     */
    const VALUE_INSERT_PHONES_SPECIFIC_DETAILS = 'Insert Phones - Specific Details';
    /**
     * Constant for value 'Insert Users'
     * @return string 'Insert Users'
     */
    const VALUE_INSERT_USERS = 'Insert Users';
    /**
     * Constant for value 'Insert UDP - All Details'
     * @return string 'Insert UDP - All Details'
     */
    const VALUE_INSERT_UDP_ALL_DETAILS = 'Insert UDP - All Details';
    /**
     * Constant for value 'Insert UDP - Specific Details'
     * @return string 'Insert UDP - Specific Details'
     */
    const VALUE_INSERT_UDP_SPECIFIC_DETAILS = 'Insert UDP - Specific Details';
    /**
     * Constant for value 'Insert Gateways'
     * @return string 'Insert Gateways'
     */
    const VALUE_INSERT_GATEWAYS = 'Insert Gateways';
    /**
     * Constant for value 'Insert CAT6k FXS Ports'
     * @return string 'Insert CAT6k FXS Ports'
     */
    const VALUE_INSERT_CAT_6_K_FXS_PORTS = 'Insert CAT6k FXS Ports';
    /**
     * Constant for value 'Insert Pickup Groups'
     * @return string 'Insert Pickup Groups'
     */
    const VALUE_INSERT_PICKUP_GROUPS = 'Insert Pickup Groups';
    /**
     * Constant for value 'Insert Forced Authorization Codes'
     * @return string 'Insert Forced Authorization Codes'
     */
    const VALUE_INSERT_FORCED_AUTHORIZATION_CODES = 'Insert Forced Authorization Codes';
    /**
     * Constant for value 'Insert Client Matter Codes'
     * @return string 'Insert Client Matter Codes'
     */
    const VALUE_INSERT_CLIENT_MATTER_CODES = 'Insert Client Matter Codes';
    /**
     * Constant for value 'Insert Phones/users'
     * @return string 'Insert Phones/users'
     */
    const VALUE_INSERT_PHONES_USERS = 'Insert Phones/users';
    /**
     * Constant for value 'Insert Managers'
     * @return string 'Insert Managers'
     */
    const VALUE_INSERT_MANAGERS = 'Insert Managers';
    /**
     * Constant for value 'Insert Assistants'
     * @return string 'Insert Assistants'
     */
    const VALUE_INSERT_ASSISTANTS = 'Insert Assistants';
    /**
     * Constant for value 'Insert Manager/Assistants'
     * @return string 'Insert Manager/Assistants'
     */
    const VALUE_INSERT_MANAGER_ASSISTANTS = 'Insert Manager/Assistants';
    /**
     * Constant for value 'Delete Phones - Query'
     * @return string 'Delete Phones - Query'
     */
    const VALUE_DELETE_PHONES_QUERY = 'Delete Phones - Query';
    /**
     * Constant for value 'Delete UDP - Query'
     * @return string 'Delete UDP - Query'
     */
    const VALUE_DELETE_UDP_QUERY = 'Delete UDP - Query';
    /**
     * Constant for value 'Delete Users - Query'
     * @return string 'Delete Users - Query'
     */
    const VALUE_DELETE_USERS_QUERY = 'Delete Users - Query';
    /**
     * Constant for value 'Delete Managers - Query'
     * @return string 'Delete Managers - Query'
     */
    const VALUE_DELETE_MANAGERS_QUERY = 'Delete Managers - Query';
    /**
     * Constant for value 'Delete Assistants - Query'
     * @return string 'Delete Assistants - Query'
     */
    const VALUE_DELETE_ASSISTANTS_QUERY = 'Delete Assistants - Query';
    /**
     * Constant for value 'Delete Lines - Query'
     * @return string 'Delete Lines - Query'
     */
    const VALUE_DELETE_LINES_QUERY = 'Delete Lines - Query';
    /**
     * Constant for value 'Delete Pickup Groups - Query'
     * @return string 'Delete Pickup Groups - Query'
     */
    const VALUE_DELETE_PICKUP_GROUPS_QUERY = 'Delete Pickup Groups - Query';
    /**
     * Constant for value 'Delete Client Matter Codes'
     * @return string 'Delete Client Matter Codes'
     */
    const VALUE_DELETE_CLIENT_MATTER_CODES = 'Delete Client Matter Codes';
    /**
     * Constant for value 'Delete Forced Authorization Codes'
     * @return string 'Delete Forced Authorization Codes'
     */
    const VALUE_DELETE_FORCED_AUTHORIZATION_CODES = 'Delete Forced Authorization Codes';
    /**
     * Constant for value 'Delete Gateways - Query'
     * @return string 'Delete Gateways - Query'
     */
    const VALUE_DELETE_GATEWAYS_QUERY = 'Delete Gateways - Query';
    /**
     * Constant for value 'Delete Phones - Custom File'
     * @return string 'Delete Phones - Custom File'
     */
    const VALUE_DELETE_PHONES_CUSTOM_FILE = 'Delete Phones - Custom File';
    /**
     * Constant for value 'Delete Users - Custom File'
     * @return string 'Delete Users - Custom File'
     */
    const VALUE_DELETE_USERS_CUSTOM_FILE = 'Delete Users - Custom File';
    /**
     * Constant for value 'Delete Managers - Custom File'
     * @return string 'Delete Managers - Custom File'
     */
    const VALUE_DELETE_MANAGERS_CUSTOM_FILE = 'Delete Managers - Custom File';
    /**
     * Constant for value 'Delete CAT6k FXS Ports'
     * @return string 'Delete CAT6k FXS Ports'
     */
    const VALUE_DELETE_CAT_6_K_FXS_PORTS = 'Delete CAT6k FXS Ports';
    /**
     * Constant for value 'Delete Managers/Assistants'
     * @return string 'Delete Managers/Assistants'
     */
    const VALUE_DELETE_MANAGERS_ASSISTANTS = 'Delete Managers/Assistants';
    /**
     * Constant for value 'Update Phones - Query'
     * @return string 'Update Phones - Query'
     */
    const VALUE_UPDATE_PHONES_QUERY = 'Update Phones - Query';
    /**
     * Constant for value 'Update Users - Query'
     * @return string 'Update Users - Query'
     */
    const VALUE_UPDATE_USERS_QUERY = 'Update Users - Query';
    /**
     * Constant for value 'Update Phones - Custom File'
     * @return string 'Update Phones - Custom File'
     */
    const VALUE_UPDATE_PHONES_CUSTOM_FILE = 'Update Phones - Custom File';
    /**
     * Constant for value 'Update Users - Custom File'
     * @return string 'Update Users - Custom File'
     */
    const VALUE_UPDATE_USERS_CUSTOM_FILE = 'Update Users - Custom File';
    /**
     * Constant for value 'Update CAT6k FXS Ports - Custom File'
     * @return string 'Update CAT6k FXS Ports - Custom File'
     */
    const VALUE_UPDATE_CAT_6_K_FXS_PORTS_CUSTOM_FILE = 'Update CAT6k FXS Ports - Custom File';
    /**
     * Constant for value 'Phone Add Lines'
     * @return string 'Phone Add Lines'
     */
    const VALUE_PHONE_ADD_LINES = 'Phone Add Lines';
    /**
     * Constant for value 'Reset/Restart Phones Query'
     * @return string 'Reset/Restart Phones Query'
     */
    const VALUE_RESET_RESTART_PHONES_QUERY = 'Reset/Restart Phones Query';
    /**
     * Constant for value 'Reset/Restart Phones Custom File'
     * @return string 'Reset/Restart Phones Custom File'
     */
    const VALUE_RESET_RESTART_PHONES_CUSTOM_FILE = 'Reset/Restart Phones Custom File';
    /**
     * Constant for value 'Generate Phone Reports'
     * @return string 'Generate Phone Reports'
     */
    const VALUE_GENERATE_PHONE_REPORTS = 'Generate Phone Reports';
    /**
     * Constant for value 'Generate User Reports'
     * @return string 'Generate User Reports'
     */
    const VALUE_GENERATE_USER_REPORTS = 'Generate User Reports';
    /**
     * Constant for value 'Generate Manager Reports'
     * @return string 'Generate Manager Reports'
     */
    const VALUE_GENERATE_MANAGER_REPORTS = 'Generate Manager Reports';
    /**
     * Constant for value 'Generate Assistant Reports'
     * @return string 'Generate Assistant Reports'
     */
    const VALUE_GENERATE_ASSISTANT_REPORTS = 'Generate Assistant Reports';
    /**
     * Constant for value 'Generate User Device Profile Reports'
     * @return string 'Generate User Device Profile Reports'
     */
    const VALUE_GENERATE_USER_DEVICE_PROFILE_REPORTS = 'Generate User Device Profile Reports';
    /**
     * Constant for value 'Generate Gateway Reports'
     * @return string 'Generate Gateway Reports'
     */
    const VALUE_GENERATE_GATEWAY_REPORTS = 'Generate Gateway Reports';
    /**
     * Constant for value 'Export Phones - All Details'
     * @return string 'Export Phones - All Details'
     */
    const VALUE_EXPORT_PHONES_ALL_DETAILS = 'Export Phones - All Details';
    /**
     * Constant for value 'Export Phones - Specific Details'
     * @return string 'Export Phones - Specific Details'
     */
    const VALUE_EXPORT_PHONES_SPECIFIC_DETAILS = 'Export Phones - Specific Details';
    /**
     * Constant for value 'Export UDP - All Details'
     * @return string 'Export UDP - All Details'
     */
    const VALUE_EXPORT_UDP_ALL_DETAILS = 'Export UDP - All Details';
    /**
     * Constant for value 'Export UDP - Specific Details'
     * @return string 'Export UDP - Specific Details'
     */
    const VALUE_EXPORT_UDP_SPECIFIC_DETAILS = 'Export UDP - Specific Details';
    /**
     * Constant for value 'Export Users'
     * @return string 'Export Users'
     */
    const VALUE_EXPORT_USERS = 'Export Users';
    /**
     * Constant for value 'Reset users Pwd/Pin Query'
     * @return string 'Reset users Pwd/Pin Query'
     */
    const VALUE_RESET_USERS_PWD_PIN_QUERY = 'Reset users Pwd/Pin Query';
    /**
     * Constant for value 'Reset users Pwd/Pin Custom'
     * @return string 'Reset users Pwd/Pin Custom'
     */
    const VALUE_RESET_USERS_PWD_PIN_CUSTOM = 'Reset users Pwd/Pin Custom';
    /**
     * Constant for value 'Phone CAPF Configuration'
     * @return string 'Phone CAPF Configuration'
     */
    const VALUE_PHONE_CAPF_CONFIGURATION = 'Phone CAPF Configuration';
    /**
     * Constant for value 'Generate UDP'
     * @return string 'Generate UDP'
     */
    const VALUE_GENERATE_UDP = 'Generate UDP';
    /**
     * Constant for value 'Delete Assistants - Custom File'
     * @return string 'Delete Assistants - Custom File'
     */
    const VALUE_DELETE_ASSISTANTS_CUSTOM_FILE = 'Delete Assistants - Custom File';
    /**
     * Constant for value 'Add Phone File Format'
     * @return string 'Add Phone File Format'
     */
    const VALUE_ADD_PHONE_FILE_FORMAT = 'Add Phone File Format';
    /**
     * Constant for value 'Add UDP File Format'
     * @return string 'Add UDP File Format'
     */
    const VALUE_ADD_UDP_FILE_FORMAT = 'Add UDP File Format';
    /**
     * Constant for value 'Add User File Format'
     * @return string 'Add User File Format'
     */
    const VALUE_ADD_USER_FILE_FORMAT = 'Add User File Format';
    /**
     * Constant for value 'Phone File Format'
     * @return string 'Phone File Format'
     */
    const VALUE_PHONE_FILE_FORMAT = 'Phone File Format';
    /**
     * Constant for value 'UDP File Format'
     * @return string 'UDP File Format'
     */
    const VALUE_UDP_FILE_FORMAT = 'UDP File Format';
    /**
     * Constant for value 'User File Format'
     * @return string 'User File Format'
     */
    const VALUE_USER_FILE_FORMAT = 'User File Format';
    /**
     * Constant for value 'Delete UDP - Custom File'
     * @return string 'Delete UDP - Custom File'
     */
    const VALUE_DELETE_UDP_CUSTOM_FILE = 'Delete UDP - Custom File';
    /**
     * Constant for value 'Delete VG200 Gateways - Custom File'
     * @return string 'Delete VG200 Gateways - Custom File'
     */
    const VALUE_DELETE_VG_200_GATEWAYS_CUSTOM_FILE = 'Delete VG200 Gateways - Custom File';
    /**
     * Constant for value 'Validate Phones - All Details'
     * @return string 'Validate Phones - All Details'
     */
    const VALUE_VALIDATE_PHONES_ALL_DETAILS = 'Validate Phones - All Details';
    /**
     * Constant for value 'Validate Phones - Specific Details'
     * @return string 'Validate Phones - Specific Details'
     */
    const VALUE_VALIDATE_PHONES_SPECIFIC_DETAILS = 'Validate Phones - Specific Details';
    /**
     * Constant for value 'Validate UDP - All Details'
     * @return string 'Validate UDP - All Details'
     */
    const VALUE_VALIDATE_UDP_ALL_DETAILS = 'Validate UDP - All Details';
    /**
     * Constant for value 'Validate UDP - Specific Details'
     * @return string 'Validate UDP - Specific Details'
     */
    const VALUE_VALIDATE_UDP_SPECIFIC_DETAILS = 'Validate UDP - Specific Details';
    /**
     * Constant for value 'Validate Users'
     * @return string 'Validate Users'
     */
    const VALUE_VALIDATE_USERS = 'Validate Users';
    /**
     * Constant for value 'UDP Add Lines'
     * @return string 'UDP Add Lines'
     */
    const VALUE_UDP_ADD_LINES = 'UDP Add Lines';
    /**
     * Constant for value 'Update Phones - CSV File'
     * @return string 'Update Phones - CSV File'
     */
    const VALUE_UPDATE_PHONES_CSV_FILE = 'Update Phones - CSV File';
    /**
     * Constant for value 'Update Lines - Query'
     * @return string 'Update Lines - Query'
     */
    const VALUE_UPDATE_LINES_QUERY = 'Update Lines - Query';
    /**
     * Constant for value 'Validate Phones/Users'
     * @return string 'Validate Phones/Users'
     */
    const VALUE_VALIDATE_PHONES_USERS = 'Validate Phones/Users';
    /**
     * Constant for value 'BAT Excel CSV Tool'
     * @return string 'BAT Excel CSV Tool'
     */
    const VALUE_BAT_EXCEL_CSV_TOOL = 'BAT Excel CSV Tool';
    /**
     * Constant for value 'Manager File Format'
     * @return string 'Manager File Format'
     */
    const VALUE_MANAGER_FILE_FORMAT = 'Manager File Format';
    /**
     * Constant for value 'Assistant File Format'
     * @return string 'Assistant File Format'
     */
    const VALUE_ASSISTANT_FILE_FORMAT = 'Assistant File Format';
    /**
     * Constant for value 'Add Phones Users File Format'
     * @return string 'Add Phones Users File Format'
     */
    const VALUE_ADD_PHONES_USERS_FILE_FORMAT = 'Add Phones Users File Format';
    /**
     * Constant for value 'Migrate Phones - SCCP TO SIP'
     * @return string 'Migrate Phones - SCCP TO SIP'
     */
    const VALUE_MIGRATE_PHONES_SCCP_TO_SIP = 'Migrate Phones - SCCP TO SIP';
    /**
     * Constant for value 'Export Configuration'
     * @return string 'Export Configuration'
     */
    const VALUE_EXPORT_CONFIGURATION = 'Export Configuration';
    /**
     * Constant for value 'Import Configuration'
     * @return string 'Import Configuration'
     */
    const VALUE_IMPORT_CONFIGURATION = 'Import Configuration';
    /**
     * Constant for value 'Update CUP Users - Custom File'
     * @return string 'Update CUP Users - Custom File'
     */
    const VALUE_UPDATE_CUP_USERS_CUSTOM_FILE = 'Update CUP Users - Custom File';
    /**
     * Constant for value 'Export CUP Users'
     * @return string 'Export CUP Users'
     */
    const VALUE_EXPORT_CUP_USERS = 'Export CUP Users';
    /**
     * Constant for value 'Populate/Depopulate Region Matrix'
     * @return string 'Populate/Depopulate Region Matrix'
     */
    const VALUE_POPULATE_DEPOPULATE_REGION_MATRIX = 'Populate/Depopulate Region Matrix';
    /**
     * Constant for value 'Update Line Appearance - Custom File'
     * @return string 'Update Line Appearance - Custom File'
     */
    const VALUE_UPDATE_LINE_APPEARANCE_CUSTOM_FILE = 'Update Line Appearance - Custom File';
    /**
     * Constant for value 'Export Line Appearance'
     * @return string 'Export Line Appearance'
     */
    const VALUE_EXPORT_LINE_APPEARANCE = 'Export Line Appearance';
    /**
     * Constant for value 'Insert Access List'
     * @return string 'Insert Access List'
     */
    const VALUE_INSERT_ACCESS_LIST = 'Insert Access List';
    /**
     * Constant for value 'Delete Access List'
     * @return string 'Delete Access List'
     */
    const VALUE_DELETE_ACCESS_LIST = 'Delete Access List';
    /**
     * Constant for value 'Export Access List'
     * @return string 'Export Access List'
     */
    const VALUE_EXPORT_ACCESS_LIST = 'Export Access List';
    /**
     * Constant for value 'Access List File Format'
     * @return string 'Access List File Format'
     */
    const VALUE_ACCESS_LIST_FILE_FORMAT = 'Access List File Format';
    /**
     * Constant for value 'Insert Remote Destination Profiles'
     * @return string 'Insert Remote Destination Profiles'
     */
    const VALUE_INSERT_REMOTE_DESTINATION_PROFILES = 'Insert Remote Destination Profiles';
    /**
     * Constant for value 'Delete Remote Destination Profiles'
     * @return string 'Delete Remote Destination Profiles'
     */
    const VALUE_DELETE_REMOTE_DESTINATION_PROFILES = 'Delete Remote Destination Profiles';
    /**
     * Constant for value 'Export Remote Destination Profiles'
     * @return string 'Export Remote Destination Profiles'
     */
    const VALUE_EXPORT_REMOTE_DESTINATION_PROFILES = 'Export Remote Destination Profiles';
    /**
     * Constant for value 'Insert Remote Destination'
     * @return string 'Insert Remote Destination'
     */
    const VALUE_INSERT_REMOTE_DESTINATION = 'Insert Remote Destination';
    /**
     * Constant for value 'Delete Remote Destination'
     * @return string 'Delete Remote Destination'
     */
    const VALUE_DELETE_REMOTE_DESTINATION = 'Delete Remote Destination';
    /**
     * Constant for value 'Export Remote Destination'
     * @return string 'Export Remote Destination'
     */
    const VALUE_EXPORT_REMOTE_DESTINATION = 'Export Remote Destination';
    /**
     * Constant for value 'Remote Destination File Format'
     * @return string 'Remote Destination File Format'
     */
    const VALUE_REMOTE_DESTINATION_FILE_FORMAT = 'Remote Destination File Format';
    /**
     * Constant for value 'Remote Destination Profile File Format'
     * @return string 'Remote Destination Profile File Format'
     */
    const VALUE_REMOTE_DESTINATION_PROFILE_FILE_FORMAT = 'Remote Destination Profile File Format';
    /**
     * Constant for value 'Add Remote Destination Profile File Format'
     * @return string 'Add Remote Destination Profile File Format'
     */
    const VALUE_ADD_REMOTE_DESTINATION_PROFILE_FILE_FORMAT = 'Add Remote Destination Profile File Format';
    /**
     * Constant for value 'config Dependency File'
     * @return string 'config Dependency File'
     */
    const VALUE_CONFIG_DEPENDENCY_FILE = 'config Dependency File';
    /**
     * Constant for value 'Update Intercom DNs - Query'
     * @return string 'Update Intercom DNs - Query'
     */
    const VALUE_UPDATE_INTERCOM_DNS_QUERY = 'Update Intercom DNs - Query';
    /**
     * Constant for value 'Insert Intercom DNs'
     * @return string 'Insert Intercom DNs'
     */
    const VALUE_INSERT_INTERCOM_DNS = 'Insert Intercom DNs';
    /**
     * Constant for value 'Add Gateway File Format'
     * @return string 'Add Gateway File Format'
     */
    const VALUE_ADD_GATEWAY_FILE_FORMAT = 'Add Gateway File Format';
    /**
     * Constant for value 'Gateway File Format'
     * @return string 'Gateway File Format'
     */
    const VALUE_GATEWAY_FILE_FORMAT = 'Gateway File Format';
    /**
     * Constant for value 'Validate Configuration Items'
     * @return string 'Validate Configuration Items'
     */
    const VALUE_VALIDATE_CONFIGURATION_ITEMS = 'Validate Configuration Items';
    /**
     * Constant for value 'Delete Unassigned DN - Query'
     * @return string 'Delete Unassigned DN - Query'
     */
    const VALUE_DELETE_UNASSIGNED_DN_QUERY = 'Delete Unassigned DN - Query';
    /**
     * Constant for value 'Insert UDP Intercom DNs'
     * @return string 'Insert UDP Intercom DNs'
     */
    const VALUE_INSERT_UDP_INTERCOM_DNS = 'Insert UDP Intercom DNs';
    /**
     * Constant for value 'Phone Migration'
     * @return string 'Phone Migration'
     */
    const VALUE_PHONE_MIGRATION = 'Phone Migration';
    /**
     * Constant for value 'Insert EMCC'
     * @return string 'Insert EMCC'
     */
    const VALUE_INSERT_EMCC = 'Insert EMCC';
    /**
     * Constant for value 'Update EMCC'
     * @return string 'Update EMCC'
     */
    const VALUE_UPDATE_EMCC = 'Update EMCC';
    /**
     * Constant for value 'Delete EMCC'
     * @return string 'Delete EMCC'
     */
    const VALUE_DELETE_EMCC = 'Delete EMCC';
    /**
     * Constant for value 'EMCC Template'
     * @return string 'EMCC Template'
     */
    const VALUE_EMCC_TEMPLATE = 'EMCC Template';
    /**
     * Constant for value 'Insert Exclusion Group'
     * @return string 'Insert Exclusion Group'
     */
    const VALUE_INSERT_EXCLUSION_GROUP = 'Insert Exclusion Group';
    /**
     * Constant for value 'Delete Exclusion Group'
     * @return string 'Delete Exclusion Group'
     */
    const VALUE_DELETE_EXCLUSION_GROUP = 'Delete Exclusion Group';
    /**
     * Constant for value 'Insert Trust Group'
     * @return string 'Insert Trust Group'
     */
    const VALUE_INSERT_TRUST_GROUP = 'Insert Trust Group';
    /**
     * Constant for value 'Delete Trust Group'
     * @return string 'Delete Trust Group'
     */
    const VALUE_DELETE_TRUST_GROUP = 'Delete Trust Group';
    /**
     * Constant for value 'Insert Trust Element'
     * @return string 'Insert Trust Element'
     */
    const VALUE_INSERT_TRUST_ELEMENT = 'Insert Trust Element';
    /**
     * Constant for value 'Delete Trust Element'
     * @return string 'Delete Trust Element'
     */
    const VALUE_DELETE_TRUST_ELEMENT = 'Delete Trust Element';
    /**
     * Constant for value 'Insert Enrolled Group'
     * @return string 'Insert Enrolled Group'
     */
    const VALUE_INSERT_ENROLLED_GROUP = 'Insert Enrolled Group';
    /**
     * Constant for value 'Delete Enrolled Group'
     * @return string 'Delete Enrolled Group'
     */
    const VALUE_DELETE_ENROLLED_GROUP = 'Delete Enrolled Group';
    /**
     * Constant for value 'Insert FallBack Profile'
     * @return string 'Insert FallBack Profile'
     */
    const VALUE_INSERT_FALL_BACK_PROFILE = 'Insert FallBack Profile';
    /**
     * Constant for value 'Delete FallBack Profile'
     * @return string 'Delete FallBack Profile'
     */
    const VALUE_DELETE_FALL_BACK_PROFILE = 'Delete FallBack Profile';
    /**
     * Constant for value 'Insert End User CAPF Profile'
     * @return string 'Insert End User CAPF Profile'
     */
    const VALUE_INSERT_END_USER_CAPF_PROFILE = 'Insert End User CAPF Profile';
    /**
     * Constant for value 'Delete End User CAPF Profile'
     * @return string 'Delete End User CAPF Profile'
     */
    const VALUE_DELETE_END_USER_CAPF_PROFILE = 'Delete End User CAPF Profile';
    /**
     * Constant for value 'Export End User CAPF Profile'
     * @return string 'Export End User CAPF Profile'
     */
    const VALUE_EXPORT_END_USER_CAPF_PROFILE = 'Export End User CAPF Profile';
    /**
     * Constant for value 'End User CAPF Profile Format'
     * @return string 'End User CAPF Profile Format'
     */
    const VALUE_END_USER_CAPF_PROFILE_FORMAT = 'End User CAPF Profile Format';
    /**
     * Constant for value 'Insert Mobility Profile'
     * @return string 'Insert Mobility Profile'
     */
    const VALUE_INSERT_MOBILITY_PROFILE = 'Insert Mobility Profile';
    /**
     * Constant for value 'Delete Mobility Profile'
     * @return string 'Delete Mobility Profile'
     */
    const VALUE_DELETE_MOBILITY_PROFILE = 'Delete Mobility Profile';
    /**
     * Constant for value 'Export Mobility Profile'
     * @return string 'Export Mobility Profile'
     */
    const VALUE_EXPORT_MOBILITY_PROFILE = 'Export Mobility Profile';
    /**
     * Constant for value 'Mobility Profile Format'
     * @return string 'Mobility Profile Format'
     */
    const VALUE_MOBILITY_PROFILE_FORMAT = 'Mobility Profile Format';
    /**
     * Constant for value 'Update UDP - Query'
     * @return string 'Update UDP - Query'
     */
    const VALUE_UPDATE_UDP_QUERY = 'Update UDP - Query';
    /**
     * Constant for value 'Update UDP - Custom File'
     * @return string 'Update UDP - Custom File'
     */
    const VALUE_UPDATE_UDP_CUSTOM_FILE = 'Update UDP - Custom File';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INSERT_PHONES_ALL_DETAILS
     * @uses self::VALUE_INSERT_PHONES_SPECIFIC_DETAILS
     * @uses self::VALUE_INSERT_USERS
     * @uses self::VALUE_INSERT_UDP_ALL_DETAILS
     * @uses self::VALUE_INSERT_UDP_SPECIFIC_DETAILS
     * @uses self::VALUE_INSERT_GATEWAYS
     * @uses self::VALUE_INSERT_CAT_6_K_FXS_PORTS
     * @uses self::VALUE_INSERT_PICKUP_GROUPS
     * @uses self::VALUE_INSERT_FORCED_AUTHORIZATION_CODES
     * @uses self::VALUE_INSERT_CLIENT_MATTER_CODES
     * @uses self::VALUE_INSERT_PHONES_USERS
     * @uses self::VALUE_INSERT_MANAGERS
     * @uses self::VALUE_INSERT_ASSISTANTS
     * @uses self::VALUE_INSERT_MANAGER_ASSISTANTS
     * @uses self::VALUE_DELETE_PHONES_QUERY
     * @uses self::VALUE_DELETE_UDP_QUERY
     * @uses self::VALUE_DELETE_USERS_QUERY
     * @uses self::VALUE_DELETE_MANAGERS_QUERY
     * @uses self::VALUE_DELETE_ASSISTANTS_QUERY
     * @uses self::VALUE_DELETE_LINES_QUERY
     * @uses self::VALUE_DELETE_PICKUP_GROUPS_QUERY
     * @uses self::VALUE_DELETE_CLIENT_MATTER_CODES
     * @uses self::VALUE_DELETE_FORCED_AUTHORIZATION_CODES
     * @uses self::VALUE_DELETE_GATEWAYS_QUERY
     * @uses self::VALUE_DELETE_PHONES_CUSTOM_FILE
     * @uses self::VALUE_DELETE_USERS_CUSTOM_FILE
     * @uses self::VALUE_DELETE_MANAGERS_CUSTOM_FILE
     * @uses self::VALUE_DELETE_CAT_6_K_FXS_PORTS
     * @uses self::VALUE_DELETE_MANAGERS_ASSISTANTS
     * @uses self::VALUE_UPDATE_PHONES_QUERY
     * @uses self::VALUE_UPDATE_USERS_QUERY
     * @uses self::VALUE_UPDATE_PHONES_CUSTOM_FILE
     * @uses self::VALUE_UPDATE_USERS_CUSTOM_FILE
     * @uses self::VALUE_UPDATE_CAT_6_K_FXS_PORTS_CUSTOM_FILE
     * @uses self::VALUE_PHONE_ADD_LINES
     * @uses self::VALUE_RESET_RESTART_PHONES_QUERY
     * @uses self::VALUE_RESET_RESTART_PHONES_CUSTOM_FILE
     * @uses self::VALUE_GENERATE_PHONE_REPORTS
     * @uses self::VALUE_GENERATE_USER_REPORTS
     * @uses self::VALUE_GENERATE_MANAGER_REPORTS
     * @uses self::VALUE_GENERATE_ASSISTANT_REPORTS
     * @uses self::VALUE_GENERATE_USER_DEVICE_PROFILE_REPORTS
     * @uses self::VALUE_GENERATE_GATEWAY_REPORTS
     * @uses self::VALUE_EXPORT_PHONES_ALL_DETAILS
     * @uses self::VALUE_EXPORT_PHONES_SPECIFIC_DETAILS
     * @uses self::VALUE_EXPORT_UDP_ALL_DETAILS
     * @uses self::VALUE_EXPORT_UDP_SPECIFIC_DETAILS
     * @uses self::VALUE_EXPORT_USERS
     * @uses self::VALUE_RESET_USERS_PWD_PIN_QUERY
     * @uses self::VALUE_RESET_USERS_PWD_PIN_CUSTOM
     * @uses self::VALUE_PHONE_CAPF_CONFIGURATION
     * @uses self::VALUE_GENERATE_UDP
     * @uses self::VALUE_DELETE_ASSISTANTS_CUSTOM_FILE
     * @uses self::VALUE_ADD_PHONE_FILE_FORMAT
     * @uses self::VALUE_ADD_UDP_FILE_FORMAT
     * @uses self::VALUE_ADD_USER_FILE_FORMAT
     * @uses self::VALUE_PHONE_FILE_FORMAT
     * @uses self::VALUE_UDP_FILE_FORMAT
     * @uses self::VALUE_USER_FILE_FORMAT
     * @uses self::VALUE_DELETE_UDP_CUSTOM_FILE
     * @uses self::VALUE_DELETE_VG_200_GATEWAYS_CUSTOM_FILE
     * @uses self::VALUE_VALIDATE_PHONES_ALL_DETAILS
     * @uses self::VALUE_VALIDATE_PHONES_SPECIFIC_DETAILS
     * @uses self::VALUE_VALIDATE_UDP_ALL_DETAILS
     * @uses self::VALUE_VALIDATE_UDP_SPECIFIC_DETAILS
     * @uses self::VALUE_VALIDATE_USERS
     * @uses self::VALUE_UDP_ADD_LINES
     * @uses self::VALUE_UPDATE_PHONES_CSV_FILE
     * @uses self::VALUE_UPDATE_LINES_QUERY
     * @uses self::VALUE_VALIDATE_PHONES_USERS
     * @uses self::VALUE_BAT_EXCEL_CSV_TOOL
     * @uses self::VALUE_MANAGER_FILE_FORMAT
     * @uses self::VALUE_ASSISTANT_FILE_FORMAT
     * @uses self::VALUE_ADD_PHONES_USERS_FILE_FORMAT
     * @uses self::VALUE_MIGRATE_PHONES_SCCP_TO_SIP
     * @uses self::VALUE_EXPORT_CONFIGURATION
     * @uses self::VALUE_IMPORT_CONFIGURATION
     * @uses self::VALUE_UPDATE_CUP_USERS_CUSTOM_FILE
     * @uses self::VALUE_EXPORT_CUP_USERS
     * @uses self::VALUE_POPULATE_DEPOPULATE_REGION_MATRIX
     * @uses self::VALUE_UPDATE_LINE_APPEARANCE_CUSTOM_FILE
     * @uses self::VALUE_EXPORT_LINE_APPEARANCE
     * @uses self::VALUE_INSERT_ACCESS_LIST
     * @uses self::VALUE_DELETE_ACCESS_LIST
     * @uses self::VALUE_EXPORT_ACCESS_LIST
     * @uses self::VALUE_ACCESS_LIST_FILE_FORMAT
     * @uses self::VALUE_INSERT_REMOTE_DESTINATION_PROFILES
     * @uses self::VALUE_DELETE_REMOTE_DESTINATION_PROFILES
     * @uses self::VALUE_EXPORT_REMOTE_DESTINATION_PROFILES
     * @uses self::VALUE_INSERT_REMOTE_DESTINATION
     * @uses self::VALUE_DELETE_REMOTE_DESTINATION
     * @uses self::VALUE_EXPORT_REMOTE_DESTINATION
     * @uses self::VALUE_REMOTE_DESTINATION_FILE_FORMAT
     * @uses self::VALUE_REMOTE_DESTINATION_PROFILE_FILE_FORMAT
     * @uses self::VALUE_ADD_REMOTE_DESTINATION_PROFILE_FILE_FORMAT
     * @uses self::VALUE_CONFIG_DEPENDENCY_FILE
     * @uses self::VALUE_UPDATE_INTERCOM_DNS_QUERY
     * @uses self::VALUE_INSERT_INTERCOM_DNS
     * @uses self::VALUE_ADD_GATEWAY_FILE_FORMAT
     * @uses self::VALUE_GATEWAY_FILE_FORMAT
     * @uses self::VALUE_VALIDATE_CONFIGURATION_ITEMS
     * @uses self::VALUE_DELETE_UNASSIGNED_DN_QUERY
     * @uses self::VALUE_INSERT_UDP_INTERCOM_DNS
     * @uses self::VALUE_PHONE_MIGRATION
     * @uses self::VALUE_INSERT_EMCC
     * @uses self::VALUE_UPDATE_EMCC
     * @uses self::VALUE_DELETE_EMCC
     * @uses self::VALUE_EMCC_TEMPLATE
     * @uses self::VALUE_INSERT_EXCLUSION_GROUP
     * @uses self::VALUE_DELETE_EXCLUSION_GROUP
     * @uses self::VALUE_INSERT_TRUST_GROUP
     * @uses self::VALUE_DELETE_TRUST_GROUP
     * @uses self::VALUE_INSERT_TRUST_ELEMENT
     * @uses self::VALUE_DELETE_TRUST_ELEMENT
     * @uses self::VALUE_INSERT_ENROLLED_GROUP
     * @uses self::VALUE_DELETE_ENROLLED_GROUP
     * @uses self::VALUE_INSERT_FALL_BACK_PROFILE
     * @uses self::VALUE_DELETE_FALL_BACK_PROFILE
     * @uses self::VALUE_INSERT_END_USER_CAPF_PROFILE
     * @uses self::VALUE_DELETE_END_USER_CAPF_PROFILE
     * @uses self::VALUE_EXPORT_END_USER_CAPF_PROFILE
     * @uses self::VALUE_END_USER_CAPF_PROFILE_FORMAT
     * @uses self::VALUE_INSERT_MOBILITY_PROFILE
     * @uses self::VALUE_DELETE_MOBILITY_PROFILE
     * @uses self::VALUE_EXPORT_MOBILITY_PROFILE
     * @uses self::VALUE_MOBILITY_PROFILE_FORMAT
     * @uses self::VALUE_UPDATE_UDP_QUERY
     * @uses self::VALUE_UPDATE_UDP_CUSTOM_FILE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INSERT_PHONES_ALL_DETAILS,
            self::VALUE_INSERT_PHONES_SPECIFIC_DETAILS,
            self::VALUE_INSERT_USERS,
            self::VALUE_INSERT_UDP_ALL_DETAILS,
            self::VALUE_INSERT_UDP_SPECIFIC_DETAILS,
            self::VALUE_INSERT_GATEWAYS,
            self::VALUE_INSERT_CAT_6_K_FXS_PORTS,
            self::VALUE_INSERT_PICKUP_GROUPS,
            self::VALUE_INSERT_FORCED_AUTHORIZATION_CODES,
            self::VALUE_INSERT_CLIENT_MATTER_CODES,
            self::VALUE_INSERT_PHONES_USERS,
            self::VALUE_INSERT_MANAGERS,
            self::VALUE_INSERT_ASSISTANTS,
            self::VALUE_INSERT_MANAGER_ASSISTANTS,
            self::VALUE_DELETE_PHONES_QUERY,
            self::VALUE_DELETE_UDP_QUERY,
            self::VALUE_DELETE_USERS_QUERY,
            self::VALUE_DELETE_MANAGERS_QUERY,
            self::VALUE_DELETE_ASSISTANTS_QUERY,
            self::VALUE_DELETE_LINES_QUERY,
            self::VALUE_DELETE_PICKUP_GROUPS_QUERY,
            self::VALUE_DELETE_CLIENT_MATTER_CODES,
            self::VALUE_DELETE_FORCED_AUTHORIZATION_CODES,
            self::VALUE_DELETE_GATEWAYS_QUERY,
            self::VALUE_DELETE_PHONES_CUSTOM_FILE,
            self::VALUE_DELETE_USERS_CUSTOM_FILE,
            self::VALUE_DELETE_MANAGERS_CUSTOM_FILE,
            self::VALUE_DELETE_CAT_6_K_FXS_PORTS,
            self::VALUE_DELETE_MANAGERS_ASSISTANTS,
            self::VALUE_UPDATE_PHONES_QUERY,
            self::VALUE_UPDATE_USERS_QUERY,
            self::VALUE_UPDATE_PHONES_CUSTOM_FILE,
            self::VALUE_UPDATE_USERS_CUSTOM_FILE,
            self::VALUE_UPDATE_CAT_6_K_FXS_PORTS_CUSTOM_FILE,
            self::VALUE_PHONE_ADD_LINES,
            self::VALUE_RESET_RESTART_PHONES_QUERY,
            self::VALUE_RESET_RESTART_PHONES_CUSTOM_FILE,
            self::VALUE_GENERATE_PHONE_REPORTS,
            self::VALUE_GENERATE_USER_REPORTS,
            self::VALUE_GENERATE_MANAGER_REPORTS,
            self::VALUE_GENERATE_ASSISTANT_REPORTS,
            self::VALUE_GENERATE_USER_DEVICE_PROFILE_REPORTS,
            self::VALUE_GENERATE_GATEWAY_REPORTS,
            self::VALUE_EXPORT_PHONES_ALL_DETAILS,
            self::VALUE_EXPORT_PHONES_SPECIFIC_DETAILS,
            self::VALUE_EXPORT_UDP_ALL_DETAILS,
            self::VALUE_EXPORT_UDP_SPECIFIC_DETAILS,
            self::VALUE_EXPORT_USERS,
            self::VALUE_RESET_USERS_PWD_PIN_QUERY,
            self::VALUE_RESET_USERS_PWD_PIN_CUSTOM,
            self::VALUE_PHONE_CAPF_CONFIGURATION,
            self::VALUE_GENERATE_UDP,
            self::VALUE_DELETE_ASSISTANTS_CUSTOM_FILE,
            self::VALUE_ADD_PHONE_FILE_FORMAT,
            self::VALUE_ADD_UDP_FILE_FORMAT,
            self::VALUE_ADD_USER_FILE_FORMAT,
            self::VALUE_PHONE_FILE_FORMAT,
            self::VALUE_UDP_FILE_FORMAT,
            self::VALUE_USER_FILE_FORMAT,
            self::VALUE_DELETE_UDP_CUSTOM_FILE,
            self::VALUE_DELETE_VG_200_GATEWAYS_CUSTOM_FILE,
            self::VALUE_VALIDATE_PHONES_ALL_DETAILS,
            self::VALUE_VALIDATE_PHONES_SPECIFIC_DETAILS,
            self::VALUE_VALIDATE_UDP_ALL_DETAILS,
            self::VALUE_VALIDATE_UDP_SPECIFIC_DETAILS,
            self::VALUE_VALIDATE_USERS,
            self::VALUE_UDP_ADD_LINES,
            self::VALUE_UPDATE_PHONES_CSV_FILE,
            self::VALUE_UPDATE_LINES_QUERY,
            self::VALUE_VALIDATE_PHONES_USERS,
            self::VALUE_BAT_EXCEL_CSV_TOOL,
            self::VALUE_MANAGER_FILE_FORMAT,
            self::VALUE_ASSISTANT_FILE_FORMAT,
            self::VALUE_ADD_PHONES_USERS_FILE_FORMAT,
            self::VALUE_MIGRATE_PHONES_SCCP_TO_SIP,
            self::VALUE_EXPORT_CONFIGURATION,
            self::VALUE_IMPORT_CONFIGURATION,
            self::VALUE_UPDATE_CUP_USERS_CUSTOM_FILE,
            self::VALUE_EXPORT_CUP_USERS,
            self::VALUE_POPULATE_DEPOPULATE_REGION_MATRIX,
            self::VALUE_UPDATE_LINE_APPEARANCE_CUSTOM_FILE,
            self::VALUE_EXPORT_LINE_APPEARANCE,
            self::VALUE_INSERT_ACCESS_LIST,
            self::VALUE_DELETE_ACCESS_LIST,
            self::VALUE_EXPORT_ACCESS_LIST,
            self::VALUE_ACCESS_LIST_FILE_FORMAT,
            self::VALUE_INSERT_REMOTE_DESTINATION_PROFILES,
            self::VALUE_DELETE_REMOTE_DESTINATION_PROFILES,
            self::VALUE_EXPORT_REMOTE_DESTINATION_PROFILES,
            self::VALUE_INSERT_REMOTE_DESTINATION,
            self::VALUE_DELETE_REMOTE_DESTINATION,
            self::VALUE_EXPORT_REMOTE_DESTINATION,
            self::VALUE_REMOTE_DESTINATION_FILE_FORMAT,
            self::VALUE_REMOTE_DESTINATION_PROFILE_FILE_FORMAT,
            self::VALUE_ADD_REMOTE_DESTINATION_PROFILE_FILE_FORMAT,
            self::VALUE_CONFIG_DEPENDENCY_FILE,
            self::VALUE_UPDATE_INTERCOM_DNS_QUERY,
            self::VALUE_INSERT_INTERCOM_DNS,
            self::VALUE_ADD_GATEWAY_FILE_FORMAT,
            self::VALUE_GATEWAY_FILE_FORMAT,
            self::VALUE_VALIDATE_CONFIGURATION_ITEMS,
            self::VALUE_DELETE_UNASSIGNED_DN_QUERY,
            self::VALUE_INSERT_UDP_INTERCOM_DNS,
            self::VALUE_PHONE_MIGRATION,
            self::VALUE_INSERT_EMCC,
            self::VALUE_UPDATE_EMCC,
            self::VALUE_DELETE_EMCC,
            self::VALUE_EMCC_TEMPLATE,
            self::VALUE_INSERT_EXCLUSION_GROUP,
            self::VALUE_DELETE_EXCLUSION_GROUP,
            self::VALUE_INSERT_TRUST_GROUP,
            self::VALUE_DELETE_TRUST_GROUP,
            self::VALUE_INSERT_TRUST_ELEMENT,
            self::VALUE_DELETE_TRUST_ELEMENT,
            self::VALUE_INSERT_ENROLLED_GROUP,
            self::VALUE_DELETE_ENROLLED_GROUP,
            self::VALUE_INSERT_FALL_BACK_PROFILE,
            self::VALUE_DELETE_FALL_BACK_PROFILE,
            self::VALUE_INSERT_END_USER_CAPF_PROFILE,
            self::VALUE_DELETE_END_USER_CAPF_PROFILE,
            self::VALUE_EXPORT_END_USER_CAPF_PROFILE,
            self::VALUE_END_USER_CAPF_PROFILE_FORMAT,
            self::VALUE_INSERT_MOBILITY_PROFILE,
            self::VALUE_DELETE_MOBILITY_PROFILE,
            self::VALUE_EXPORT_MOBILITY_PROFILE,
            self::VALUE_MOBILITY_PROFILE_FORMAT,
            self::VALUE_UPDATE_UDP_QUERY,
            self::VALUE_UPDATE_UDP_CUSTOM_FILE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
