<?php

namespace CUCM\EnumType;

/**
 * This class stands for XApplication EnumType
 * @subpackage Enumerations
 */
class XApplication
{
    /**
     * Constant for value 'Cisco Call Manager Administration'
     * @return string 'Cisco Call Manager Administration'
     */
    const VALUE_CISCO_CALL_MANAGER_ADMINISTRATION = 'Cisco Call Manager Administration';
    /**
     * Constant for value 'Cisco Call Manager Serviceability'
     * @return string 'Cisco Call Manager Serviceability'
     */
    const VALUE_CISCO_CALL_MANAGER_SERVICEABILITY = 'Cisco Call Manager Serviceability';
    /**
     * Constant for value 'Cisco Computer Telephone Interface (CTI)'
     * @return string 'Cisco Computer Telephone Interface (CTI)'
     */
    const VALUE_CISCO_COMPUTER_TELEPHONE_INTERFACE_CTI = 'Cisco Computer Telephone Interface (CTI)';
    /**
     * Constant for value 'Cisco Call Manager AXL Database'
     * @return string 'Cisco Call Manager AXL Database'
     */
    const VALUE_CISCO_CALL_MANAGER_AXL_DATABASE = 'Cisco Call Manager AXL Database';
    /**
     * Constant for value 'Cisco Extension Mobility'
     * @return string 'Cisco Extension Mobility'
     */
    const VALUE_CISCO_EXTENSION_MOBILITY = 'Cisco Extension Mobility';
    /**
     * Constant for value 'Cisco Call Manager End User'
     * @return string 'Cisco Call Manager End User'
     */
    const VALUE_CISCO_CALL_MANAGER_END_USER = 'Cisco Call Manager End User';
    /**
     * Constant for value 'Cisco Unified Reporting'
     * @return string 'Cisco Unified Reporting'
     */
    const VALUE_CISCO_UNIFIED_REPORTING = 'Cisco Unified Reporting';
    /**
     * Constant for value 'Cisco Call Manager Dialed Number Analyser'
     * @return string 'Cisco Call Manager Dialed Number Analyser'
     */
    const VALUE_CISCO_CALL_MANAGER_DIALED_NUMBER_ANALYSER = 'Cisco Call Manager Dialed Number Analyser';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CISCO_CALL_MANAGER_ADMINISTRATION
     * @uses self::VALUE_CISCO_CALL_MANAGER_SERVICEABILITY
     * @uses self::VALUE_CISCO_COMPUTER_TELEPHONE_INTERFACE_CTI
     * @uses self::VALUE_CISCO_CALL_MANAGER_AXL_DATABASE
     * @uses self::VALUE_CISCO_EXTENSION_MOBILITY
     * @uses self::VALUE_CISCO_CALL_MANAGER_END_USER
     * @uses self::VALUE_CISCO_UNIFIED_REPORTING
     * @uses self::VALUE_CISCO_CALL_MANAGER_DIALED_NUMBER_ANALYSER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CISCO_CALL_MANAGER_ADMINISTRATION,
            self::VALUE_CISCO_CALL_MANAGER_SERVICEABILITY,
            self::VALUE_CISCO_COMPUTER_TELEPHONE_INTERFACE_CTI,
            self::VALUE_CISCO_CALL_MANAGER_AXL_DATABASE,
            self::VALUE_CISCO_EXTENSION_MOBILITY,
            self::VALUE_CISCO_CALL_MANAGER_END_USER,
            self::VALUE_CISCO_UNIFIED_REPORTING,
            self::VALUE_CISCO_CALL_MANAGER_DIALED_NUMBER_ANALYSER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
