<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for standard_result StructType
 * @subpackage Structs
 */
class Standard_result extends AbstractStructBase
{
    /**
     * The successfull
     * @var bool
     */
    public $successfull;
    /**
     * The errcode
     * @var int
     */
    public $errcode;
    /**
     * The errdesc
     * @var string
     */
    public $errdesc;
    /**
     * Constructor method for standard_result
     * @uses Standard_result::setSuccessfull()
     * @uses Standard_result::setErrcode()
     * @uses Standard_result::setErrdesc()
     * @param bool $successfull
     * @param int $errcode
     * @param string $errdesc
     */
    public function __construct($successfull = null, $errcode = null, $errdesc = null)
    {
        $this
            ->setSuccessfull($successfull)
            ->setErrcode($errcode)
            ->setErrdesc($errdesc);
    }
    /**
     * Get successfull value
     * @return bool|null
     */
    public function getSuccessfull()
    {
        return $this->successfull;
    }
    /**
     * Set successfull value
     * @param bool $successfull
     * @return \StructType\Standard_result
     */
    public function setSuccessfull($successfull = null)
    {
        // validation for constraint: boolean
        if (!is_null($successfull) && !is_bool($successfull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($successfull)), __LINE__);
        }
        $this->successfull = $successfull;
        return $this;
    }
    /**
     * Get errcode value
     * @return int|null
     */
    public function getErrcode()
    {
        return $this->errcode;
    }
    /**
     * Set errcode value
     * @param int $errcode
     * @return \StructType\Standard_result
     */
    public function setErrcode($errcode = null)
    {
        // validation for constraint: int
        if (!is_null($errcode) && !is_numeric($errcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errcode)), __LINE__);
        }
        $this->errcode = $errcode;
        return $this;
    }
    /**
     * Get errdesc value
     * @return string|null
     */
    public function getErrdesc()
    {
        return $this->errdesc;
    }
    /**
     * Set errdesc value
     * @param string $errdesc
     * @return \StructType\Standard_result
     */
    public function setErrdesc($errdesc = null)
    {
        // validation for constraint: string
        if (!is_null($errdesc) && !is_string($errdesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errdesc)), __LINE__);
        }
        $this->errdesc = $errdesc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Standard_result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
