<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for printlabelzip_result StructType
 * @subpackage Structs
 */
class Printlabelzip_result extends AbstractStructBase
{
    /**
     * The pclids
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: SOAP-ENC:arrayType
     * @var string[]
     */
    public $pclids;
    /**
     * The pdfdata
     * @var string
     */
    public $pdfdata;
    /**
     * The successfull
     * @var bool
     */
    public $successfull;
    /**
     * The errcode
     * @var int
     */
    public $errcode;
    /**
     * The errdesc
     * @var string
     */
    public $errdesc;
    /**
     * Constructor method for printlabelzip_result
     * @uses Printlabelzip_result::setPclids()
     * @uses Printlabelzip_result::setPdfdata()
     * @uses Printlabelzip_result::setSuccessfull()
     * @uses Printlabelzip_result::setErrcode()
     * @uses Printlabelzip_result::setErrdesc()
     * @param string[] $pclids
     * @param string $pdfdata
     * @param bool $successfull
     * @param int $errcode
     * @param string $errdesc
     */
    public function __construct(array $pclids = array(), $pdfdata = null, $successfull = null, $errcode = null, $errdesc = null)
    {
        $this
            ->setPclids($pclids)
            ->setPdfdata($pdfdata)
            ->setSuccessfull($successfull)
            ->setErrcode($errcode)
            ->setErrdesc($errdesc);
    }
    /**
     * Get pclids value
     * @return string[]|null
     */
    public function getPclids()
    {
        return $this->pclids;
    }
    /**
     * Set pclids value
     * @throws \InvalidArgumentException
     * @param string[] $pclids
     * @return \StructType\Printlabelzip_result
     */
    public function setPclids(array $pclids = array())
    {
        foreach ($pclids as $printlabelzip_resultPclidsItem) {
            // validation for constraint: itemType
            if (!is_string($printlabelzip_resultPclidsItem)) {
                throw new \InvalidArgumentException(sprintf('The pclids property can only contain items of string, "%s" given', is_object($printlabelzip_resultPclidsItem) ? get_class($printlabelzip_resultPclidsItem) : gettype($printlabelzip_resultPclidsItem)), __LINE__);
            }
        }
        $this->pclids = $pclids;
        return $this;
    }
    /**
     * Add item to pclids value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Printlabelzip_result
     */
    public function addToPclids($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The pclids property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->pclids[] = $item;
        return $this;
    }
    /**
     * Get pdfdata value
     * @return string|null
     */
    public function getPdfdata()
    {
        return $this->pdfdata;
    }
    /**
     * Set pdfdata value
     * @param string $pdfdata
     * @return \StructType\Printlabelzip_result
     */
    public function setPdfdata($pdfdata = null)
    {
        // validation for constraint: string
        if (!is_null($pdfdata) && !is_string($pdfdata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pdfdata)), __LINE__);
        }
        $this->pdfdata = $pdfdata;
        return $this;
    }
    /**
     * Get successfull value
     * @return bool|null
     */
    public function getSuccessfull()
    {
        return $this->successfull;
    }
    /**
     * Set successfull value
     * @param bool $successfull
     * @return \StructType\Printlabelzip_result
     */
    public function setSuccessfull($successfull = null)
    {
        // validation for constraint: boolean
        if (!is_null($successfull) && !is_bool($successfull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($successfull)), __LINE__);
        }
        $this->successfull = $successfull;
        return $this;
    }
    /**
     * Get errcode value
     * @return int|null
     */
    public function getErrcode()
    {
        return $this->errcode;
    }
    /**
     * Set errcode value
     * @param int $errcode
     * @return \StructType\Printlabelzip_result
     */
    public function setErrcode($errcode = null)
    {
        // validation for constraint: int
        if (!is_null($errcode) && !is_numeric($errcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errcode)), __LINE__);
        }
        $this->errcode = $errcode;
        return $this;
    }
    /**
     * Get errdesc value
     * @return string|null
     */
    public function getErrdesc()
    {
        return $this->errdesc;
    }
    /**
     * Set errdesc value
     * @param string $errdesc
     * @return \StructType\Printlabelzip_result
     */
    public function setErrdesc($errdesc = null)
    {
        // validation for constraint: string
        if (!is_null($errdesc) && !is_string($errdesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errdesc)), __LINE__);
        }
        $this->errdesc = $errdesc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Printlabelzip_result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
