<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for printlabel_result StructType
 * @subpackage Structs
 */
class Printlabel_result extends AbstractStructBase
{
    /**
     * The pcls
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: SOAP-ENC:arrayType
     * @var string[]
     */
    public $pcls;
    /**
     * The pcls_withcheckdigit
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: SOAP-ENC:arrayType
     * @var string[]
     */
    public $pcls_withcheckdigit;
    /**
     * The pdfdata
     * @var string
     */
    public $pdfdata;
    /**
     * The depo
     * @var string
     */
    public $depo;
    /**
     * The driver
     * @var string
     */
    public $driver;
    /**
     * The successfull
     * @var bool
     */
    public $successfull;
    /**
     * The errcode
     * @var int
     */
    public $errcode;
    /**
     * The errdesc
     * @var string
     */
    public $errdesc;
    /**
     * Constructor method for printlabel_result
     * @uses Printlabel_result::setPcls()
     * @uses Printlabel_result::setPcls_withcheckdigit()
     * @uses Printlabel_result::setPdfdata()
     * @uses Printlabel_result::setDepo()
     * @uses Printlabel_result::setDriver()
     * @uses Printlabel_result::setSuccessfull()
     * @uses Printlabel_result::setErrcode()
     * @uses Printlabel_result::setErrdesc()
     * @param string[] $pcls
     * @param string[] $pcls_withcheckdigit
     * @param string $pdfdata
     * @param string $depo
     * @param string $driver
     * @param bool $successfull
     * @param int $errcode
     * @param string $errdesc
     */
    public function __construct(array $pcls = array(), array $pcls_withcheckdigit = array(), $pdfdata = null, $depo = null, $driver = null, $successfull = null, $errcode = null, $errdesc = null)
    {
        $this
            ->setPcls($pcls)
            ->setPcls_withcheckdigit($pcls_withcheckdigit)
            ->setPdfdata($pdfdata)
            ->setDepo($depo)
            ->setDriver($driver)
            ->setSuccessfull($successfull)
            ->setErrcode($errcode)
            ->setErrdesc($errdesc);
    }
    /**
     * Get pcls value
     * @return string[]|null
     */
    public function getPcls()
    {
        return $this->pcls;
    }
    /**
     * Set pcls value
     * @throws \InvalidArgumentException
     * @param string[] $pcls
     * @return \StructType\Printlabel_result
     */
    public function setPcls(array $pcls = array())
    {
        foreach ($pcls as $printlabel_resultPclsItem) {
            // validation for constraint: itemType
            if (!is_string($printlabel_resultPclsItem)) {
                throw new \InvalidArgumentException(sprintf('The pcls property can only contain items of string, "%s" given', is_object($printlabel_resultPclsItem) ? get_class($printlabel_resultPclsItem) : gettype($printlabel_resultPclsItem)), __LINE__);
            }
        }
        $this->pcls = $pcls;
        return $this;
    }
    /**
     * Add item to pcls value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Printlabel_result
     */
    public function addToPcls($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The pcls property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->pcls[] = $item;
        return $this;
    }
    /**
     * Get pcls_withcheckdigit value
     * @return string[]|null
     */
    public function getPcls_withcheckdigit()
    {
        return $this->pcls_withcheckdigit;
    }
    /**
     * Set pcls_withcheckdigit value
     * @throws \InvalidArgumentException
     * @param string[] $pcls_withcheckdigit
     * @return \StructType\Printlabel_result
     */
    public function setPcls_withcheckdigit(array $pcls_withcheckdigit = array())
    {
        foreach ($pcls_withcheckdigit as $printlabel_resultPcls_withcheckdigitItem) {
            // validation for constraint: itemType
            if (!is_string($printlabel_resultPcls_withcheckdigitItem)) {
                throw new \InvalidArgumentException(sprintf('The pcls_withcheckdigit property can only contain items of string, "%s" given', is_object($printlabel_resultPcls_withcheckdigitItem) ? get_class($printlabel_resultPcls_withcheckdigitItem) : gettype($printlabel_resultPcls_withcheckdigitItem)), __LINE__);
            }
        }
        $this->pcls_withcheckdigit = $pcls_withcheckdigit;
        return $this;
    }
    /**
     * Add item to pcls_withcheckdigit value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Printlabel_result
     */
    public function addToPcls_withcheckdigit($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The pcls_withcheckdigit property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->pcls_withcheckdigit[] = $item;
        return $this;
    }
    /**
     * Get pdfdata value
     * @return string|null
     */
    public function getPdfdata()
    {
        return $this->pdfdata;
    }
    /**
     * Set pdfdata value
     * @param string $pdfdata
     * @return \StructType\Printlabel_result
     */
    public function setPdfdata($pdfdata = null)
    {
        // validation for constraint: string
        if (!is_null($pdfdata) && !is_string($pdfdata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pdfdata)), __LINE__);
        }
        $this->pdfdata = $pdfdata;
        return $this;
    }
    /**
     * Get depo value
     * @return string|null
     */
    public function getDepo()
    {
        return $this->depo;
    }
    /**
     * Set depo value
     * @param string $depo
     * @return \StructType\Printlabel_result
     */
    public function setDepo($depo = null)
    {
        // validation for constraint: string
        if (!is_null($depo) && !is_string($depo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depo)), __LINE__);
        }
        $this->depo = $depo;
        return $this;
    }
    /**
     * Get driver value
     * @return string|null
     */
    public function getDriver()
    {
        return $this->driver;
    }
    /**
     * Set driver value
     * @param string $driver
     * @return \StructType\Printlabel_result
     */
    public function setDriver($driver = null)
    {
        // validation for constraint: string
        if (!is_null($driver) && !is_string($driver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driver)), __LINE__);
        }
        $this->driver = $driver;
        return $this;
    }
    /**
     * Get successfull value
     * @return bool|null
     */
    public function getSuccessfull()
    {
        return $this->successfull;
    }
    /**
     * Set successfull value
     * @param bool $successfull
     * @return \StructType\Printlabel_result
     */
    public function setSuccessfull($successfull = null)
    {
        // validation for constraint: boolean
        if (!is_null($successfull) && !is_bool($successfull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($successfull)), __LINE__);
        }
        $this->successfull = $successfull;
        return $this;
    }
    /**
     * Get errcode value
     * @return int|null
     */
    public function getErrcode()
    {
        return $this->errcode;
    }
    /**
     * Set errcode value
     * @param int $errcode
     * @return \StructType\Printlabel_result
     */
    public function setErrcode($errcode = null)
    {
        // validation for constraint: int
        if (!is_null($errcode) && !is_numeric($errcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errcode)), __LINE__);
        }
        $this->errcode = $errcode;
        return $this;
    }
    /**
     * Get errdesc value
     * @return string|null
     */
    public function getErrdesc()
    {
        return $this->errdesc;
    }
    /**
     * Set errdesc value
     * @param string $errdesc
     * @return \StructType\Printlabel_result
     */
    public function setErrdesc($errdesc = null)
    {
        // validation for constraint: string
        if (!is_null($errdesc) && !is_string($errdesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errdesc)), __LINE__);
        }
        $this->errdesc = $errdesc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Printlabel_result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
