<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrepareReturn StructType
 * @subpackage Structs
 */
class PrepareReturn extends AbstractStructBase
{
    /**
     * The clientref
     * @var string
     */
    public $clientref;
    /**
     * The pclid
     * @var string
     */
    public $pclid;
    /**
     * The error
     * @var string
     */
    public $error;
    /**
     * Constructor method for PrepareReturn
     * @uses PrepareReturn::setClientref()
     * @uses PrepareReturn::setPclid()
     * @uses PrepareReturn::setError()
     * @param string $clientref
     * @param string $pclid
     * @param string $error
     */
    public function __construct($clientref = null, $pclid = null, $error = null)
    {
        $this
            ->setClientref($clientref)
            ->setPclid($pclid)
            ->setError($error);
    }
    /**
     * Get clientref value
     * @return string|null
     */
    public function getClientref()
    {
        return $this->clientref;
    }
    /**
     * Set clientref value
     * @param string $clientref
     * @return \StructType\PrepareReturn
     */
    public function setClientref($clientref = null)
    {
        // validation for constraint: string
        if (!is_null($clientref) && !is_string($clientref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientref)), __LINE__);
        }
        $this->clientref = $clientref;
        return $this;
    }
    /**
     * Get pclid value
     * @return string|null
     */
    public function getPclid()
    {
        return $this->pclid;
    }
    /**
     * Set pclid value
     * @param string $pclid
     * @return \StructType\PrepareReturn
     */
    public function setPclid($pclid = null)
    {
        // validation for constraint: string
        if (!is_null($pclid) && !is_string($pclid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pclid)), __LINE__);
        }
        $this->pclid = $pclid;
        return $this;
    }
    /**
     * Get error value
     * @return string|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param string $error
     * @return \StructType\PrepareReturn
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($error)), __LINE__);
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrepareReturn
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
