<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Printlabel ServiceType
 * @subpackage Services
 */
class Printlabel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named printlabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $username
     * @param string $password
     * @param string $senderid
     * @param string $sender_name
     * @param string $sender_address
     * @param string $sender_city
     * @param string $sender_zipcode
     * @param string $sender_country
     * @param string $sender_contact
     * @param string $sender_phone
     * @param string $sender_email
     * @param string $consig_name
     * @param string $consig_address
     * @param string $consig_city
     * @param string $consig_zipcode
     * @param string $consig_country
     * @param string $consig_contact
     * @param string $consig_phone
     * @param string $consig_email
     * @param string $pcount
     * @param string $pickupdate
     * @param string $content
     * @param string $clientref
     * @param string $codamount
     * @param string $codref
     * @param string $services
     * @param string $printertemplate
     * @param string $printit
     * @param string $timestamp
     * @param string $hash
     * @param string $customlabel
     * @param string $is_autoprint_pdfs
     * @return \StructType\Printlabel_result|bool
     */
    public function printlabel($username, $password, $senderid, $sender_name, $sender_address, $sender_city, $sender_zipcode, $sender_country, $sender_contact, $sender_phone, $sender_email, $consig_name, $consig_address, $consig_city, $consig_zipcode, $consig_country, $consig_contact, $consig_phone, $consig_email, $pcount, $pickupdate, $content, $clientref, $codamount, $codref, $services, $printertemplate, $printit, $timestamp, $hash, $customlabel, $is_autoprint_pdfs)
    {
        try {
            $this->setResult(self::getSoapClient()->printlabel($username, $password, $senderid, $sender_name, $sender_address, $sender_city, $sender_zipcode, $sender_country, $sender_contact, $sender_phone, $sender_email, $consig_name, $consig_address, $consig_city, $consig_zipcode, $consig_country, $consig_contact, $consig_phone, $consig_email, $pcount, $pickupdate, $content, $clientref, $codamount, $codref, $services, $printertemplate, $printit, $timestamp, $hash, $customlabel, $is_autoprint_pdfs));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Printlabel_result
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
