<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Preparelabels ServiceType
 * @subpackage Services
 */
class Preparelabels extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named preparelabels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $username
     * @param string $password
     * @param string $senderid
     * @param string $data
     * @return \StructType\PrepareReturn[]|bool
     */
    public function preparelabels($username, $password, $senderid, $data)
    {
        try {
            $this->setResult(self::getSoapClient()->preparelabels($username, $password, $senderid, $data));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PrepareReturn[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
