<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Modifycod ServiceType
 * @subpackage Services
 */
class Modifycod extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named modifycod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $username
     * @param string $password
     * @param string $senderid
     * @param string $pclid
     * @param string $codamount
     * @param string $email
     * @return \StructType\Standard_result|bool
     */
    public function modifycod($username, $password, $senderid, $pclid, $codamount, $email)
    {
        try {
            $this->setResult(self::getSoapClient()->modifycod($username, $password, $senderid, $pclid, $codamount, $email));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Standard_result
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
