<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Deletelabels ServiceType
 * @subpackage Services
 */
class Deletelabels extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deletelabels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $username
     * @param string $password
     * @param string $senderid
     * @param string $pclids
     * @return \StructType\Printlabel_result|bool
     */
    public function deletelabels($username, $password, $senderid, $pclids)
    {
        try {
            $this->setResult(self::getSoapClient()->deletelabels($username, $password, $senderid, $pclids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Printlabel_result
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
