<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Technical ServiceType
 * @subpackage Services
 */
class Technical extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * TechnicalPerformanceReportReturnObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TechnicalPerformanceReportReturnObject $parameters
     * @return \StructType\TechnicalPerformanceReportReturnObjectResponse|bool
     */
    public function TechnicalPerformanceReportReturnObject(\StructType\TechnicalPerformanceReportReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TechnicalPerformanceReportReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TechnicalPerformanceReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TechnicalPerformanceReport $parameters
     * @return \StructType\TechnicalPerformanceReportResponse|bool
     */
    public function TechnicalPerformanceReport(\StructType\TechnicalPerformanceReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TechnicalPerformanceReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TechnicalPerformanceReportResponse|\StructType\TechnicalPerformanceReportReturnObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
