<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Temperature ServiceType
 * @subpackage Services
 */
class Temperature extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TemperatureAlarm
     * Meta information extracted from the WSDL
     * - documentation: Sicaklik alarmlarini listeler. Bu metot ile sicaklik alarmi, tanimlanmis olan minimum-maksimum sicaklik degerleri araliginin disina cikilmasi durumunda olusan alarmlar ve alarm degerleri gosterilmektedir. - Lists the temperature
     * alarms. This method shows the alarms and alarm values that occur when the temperature alarm is out of the predefined minimum-maximum temperature range. | Sicaklik alarmlarini listeler. Bu metot ile sicaklik alarmi, tanimlanmis olan minimum-maksimum
     * sicaklik degerleri araliginin disina cikilmasi durumunda olusan alarmlar ve alarm degerleri gosterilmektedir. - Lists the temperature alarms. This method shows the alarms and alarm values that occur when the temperature alarm is out of the predefined
     * minimum-maximum temperature range. | Sicaklik alarmlarini listeler. Bu metot ile sicaklik alarmi, tanimlanmis olan minimum-maksimum sicaklik degerleri araliginin disina cikilmasi durumunda olusan alarmlar ve alarm degerleri gosterilmektedir. - Lists
     * the temperature alarms. This method shows the alarms and alarm values that occur when the temperature alarm is out of the predefined minimum-maximum temperature range.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TemperatureAlarm $parameters
     * @return \StructType\TemperatureAlarmResponse|bool
     */
    public function TemperatureAlarm(\StructType\TemperatureAlarm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TemperatureAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TemperatureAlarmResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
