<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Idling ServiceType
 * @subpackage Services
 */
class Idling extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IdlingDurationReport
     * Meta information extracted from the WSDL
     * - documentation: Rolanti zamani bilgisi listeler. Rolanti aracin kontaginin acik olup hareket etmedigi durumdur. Bu metot ile cihazin yaptigi rolanti sureleri detayli gosterilir. - List the idling durations information. Idling is when the vehicle
     * ignition is on and not moving. With this method, the idling times of the device are shown in detail. | Rolanti zamani bilgisi listeler. Rolanti aracin kontaginin acik olup hareket etmedigi durumdur. Bu metot ile cihazin yaptigi rolanti sureleri
     * detayli gosterilir. - List the idling durations information. Idling is when the vehicle ignition is on and not moving. With this method, the idling times of the device are shown in detail. | Rolanti zamani bilgisi listeler. Rolanti aracin kontaginin
     * acik olup hareket etmedigi durumdur. Bu metot ile cihazin yaptigi rolanti sureleri detayli gosterilir. - List the idling durations information. Idling is when the vehicle ignition is on and not moving. With this method, the idling times of the device
     * are shown in detail.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IdlingDurationReport $parameters
     * @return \StructType\IdlingDurationReportResponse|bool
     */
    public function IdlingDurationReport(\StructType\IdlingDurationReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IdlingDurationReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IdlingAlarm
     * Meta information extracted from the WSDL
     * - documentation: Cihazlardan gelen rolanti alarmlarini listeler. Bu metot ile, aracin hangi bolgelerde ne zaman rolanti suresini ihlal ettigi gosterilir. - Lists the idling alarms from the devices. With this method, it is shown vehicle has violated
     * the idling time | Cihazlardan gelen rolanti alarmlarini listeler. Bu metot ile, aracin hangi bolgelerde ne zaman rolanti suresini ihlal ettigi gosterilir. - Lists the idling alarms from the devices. With this method, it is shown vehicle has violated
     * the idling time | Cihazlardan gelen rolanti alarmlarini listeler. Bu metot ile, aracin hangi bolgelerde ne zaman rolanti suresini ihlal ettigi gosterilir. - Lists the idling alarms from the devices. With this method, it is shown vehicle has violated
     * the idling time
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IdlingAlarm $parameters
     * @return \StructType\IdlingAlarmResponse|bool
     */
    public function IdlingAlarm(\StructType\IdlingAlarm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IdlingAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IdlingAlarmResponse|\StructType\IdlingDurationReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
