<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ignition ServiceType
 * @subpackage Services
 */
class Ignition extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IgnitionAlarmReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Cihazdan gelen kontak acildi–kontak kapandi alarmlarinin gosterildigi kontak alarmi listesini olusturur. Kontak alarmi ile aracin ne zaman nerelerde kontak acip kapadigi bilgisi listelenir. Sonuc XmlDocument tipinde doner. - The
     * ignition information which comes from device displayed on Contact Alarm method. Contact alarm lists information about when/where the ignition has turned on and off. Result returns as XmlDocument type. | Cihazdan gelen kontak acildi–kontak kapandi
     * alarmlarinin gosterildigi kontak alarmi listesini olusturur. Kontak alarmi ile aracin ne zaman nerelerde kontak acip kapadigi bilgisi listelenir. Sonuc XmlDocument tipinde doner. - The ignition information which comes from device displayed on Contact
     * Alarm method. Contact alarm lists information about when/where the ignition has turned on and off. Result returns as XmlDocument type. | Cihazdan gelen kontak acildi–kontak kapandi alarmlarinin gosterildigi kontak alarmi listesini olusturur. Kontak
     * alarmi ile aracin ne zaman nerelerde kontak acip kapadigi bilgisi listelenir. Sonuc XmlDocument tipinde doner. - The ignition information which comes from device displayed on Contact Alarm method. Contact alarm lists information about when/where the
     * ignition has turned on and off. Result returns as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IgnitionAlarmReturnObject $parameters
     * @return \StructType\IgnitionAlarmReturnObjectResponse|bool
     */
    public function IgnitionAlarmReturnObject(\StructType\IgnitionAlarmReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IgnitionAlarmReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IgnitionDurationReport
     * Meta information extracted from the WSDL
     * - documentation: Kontak acik olmasi, aracin calisir durumda olmasidir. Bu raporda aracin kontak acik kalma sureleri gosterilir. - When ignition is on this means that vehicle is in operation. This report shows the duration of the vehicle's ignition
     * on. | Kontak acik olmasi, aracin calisir durumda olmasidir. Bu raporda aracin kontak acik kalma sureleri gosterilir. - When ignition is on this means that vehicle is in operation. This report shows the duration of the vehicle's ignition on. | Kontak
     * acik olmasi, aracin calisir durumda olmasidir. Bu raporda aracin kontak acik kalma sureleri gosterilir. - When ignition is on this means that vehicle is in operation. This report shows the duration of the vehicle's ignition on.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IgnitionDurationReport $parameters
     * @return \StructType\IgnitionDurationReportResponse|bool
     */
    public function IgnitionDurationReport(\StructType\IgnitionDurationReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IgnitionDurationReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IgnitionAlarmReturnObjectResponse|\StructType\IgnitionDurationReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
