<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Door ServiceType
 * @subpackage Services
 */
class Door extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DoorAlarm
     * Meta information extracted from the WSDL
     * - documentation: Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi alarmi ek donanim (kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. - It lists door alerts. With this method, the door alarms generated by
     * the device are listed in the vehicles with the door open / close alarm additional equipment (door sensor) . | Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi alarmi ek donanim (kapi sensoru) bulunan araclarda cihaz tarafindan uretilen
     * alarmlar listelenir. - It lists door alerts. With this method, the door alarms generated by the device are listed in the vehicles with the door open / close alarm additional equipment (door sensor) . | Kapi alarmlarini listeler. Bu metot ile kapi
     * acildi / kapandi alarmi ek donanim (kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. - It lists door alerts. With this method, the door alarms generated by the device are listed in the vehicles with the door open / close
     * alarm additional equipment (door sensor) .
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoorAlarm $parameters
     * @return \StructType\DoorAlarmResponse|bool
     */
    public function DoorAlarm(\StructType\DoorAlarm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DoorAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DoorAlarm2
     * Meta information extracted from the WSDL
     * - documentation: Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi alarmi ek donanim(kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. - It lists door alerts. With this method, alarms generated by the device
     * are listed in the vehicles with the door open / close alarm additional equipment (door sensor). | Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi alarmi ek donanim(kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar
     * listelenir. - It lists door alerts. With this method, alarms generated by the device are listed in the vehicles with the door open / close alarm additional equipment (door sensor). | Kapi alarmlarini listeler. Bu metot ile kapi acildi / kapandi
     * alarmi ek donanim(kapi sensoru) bulunan araclarda cihaz tarafindan uretilen alarmlar listelenir. - It lists door alerts. With this method, alarms generated by the device are listed in the vehicles with the door open / close alarm additional equipment
     * (door sensor).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoorAlarm2 $parameters
     * @return \StructType\DoorAlarm2Response|bool
     */
    public function DoorAlarm2(\StructType\DoorAlarm2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DoorAlarm2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DoorAlarm2Response|\StructType\DoorAlarmResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
