<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Driver ServiceType
 * @subpackage Services
 */
class Driver extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DriverPrivateUsageReport
     * Meta information extracted from the WSDL
     * - documentation: Surucu ozel kullanim durumunu raporlar. - It reports driver private usage report. | Surucu ozel kullanim durumunu raporlar. - It reports driver private usage report. | Surucu ozel kullanim durumunu raporlar. - It reports driver
     * private usage report.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DriverPrivateUsageReport $parameters
     * @return \StructType\DriverPrivateUsageReportResponse|bool
     */
    public function DriverPrivateUsageReport(\StructType\DriverPrivateUsageReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DriverPrivateUsageReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DriverPrivateUsageReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
