<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for General ServiceType
 * @subpackage Services
 */
class General extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GeneralReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneralReport $parameters
     * @return \StructType\GeneralReportResponse|bool
     */
    public function GeneralReport(\StructType\GeneralReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GeneralReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GeneralReportReturnObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneralReportReturnObject $parameters
     * @return \StructType\GeneralReportReturnObjectResponse|bool
     */
    public function GeneralReportReturnObject(\StructType\GeneralReportReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GeneralReportReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GeneralReport2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneralReport2 $parameters
     * @return \StructType\GeneralReport2Response|bool
     */
    public function GeneralReport2(\StructType\GeneralReport2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GeneralReport2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GeneralReportWithDistance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneralReportWithDistance $parameters
     * @return \StructType\GeneralReportWithDistanceResponse|bool
     */
    public function GeneralReportWithDistance(\StructType\GeneralReportWithDistance $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GeneralReportWithDistance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GeneralReportWithDistanceReturnObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneralReportWithDistanceReturnObject $parameters
     * @return \StructType\GeneralReportWithDistanceReturnObjectResponse|bool
     */
    public function GeneralReportWithDistanceReturnObject(\StructType\GeneralReportWithDistanceReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GeneralReportWithDistanceReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GeneralReport2Response|\StructType\GeneralReportResponse|\StructType\GeneralReportReturnObjectResponse|\StructType\GeneralReportWithDistanceResponse|\StructType\GeneralReportWithDistanceReturnObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
