<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Parallel ServiceType
 * @subpackage Services
 */
class Parallel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ParallelTimingReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ParallelTimingReport $parameters
     * @return \StructType\ParallelTimingReportResponse|bool
     */
    public function ParallelTimingReport(\StructType\ParallelTimingReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ParallelTimingReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ParallelTimingReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
