<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Building ServiceType
 * @subpackage Services
 */
class Building extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BuildingListReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BuildingListReport $parameters
     * @return \StructType\BuildingListReportResponse|bool
     */
    public function BuildingListReport(\StructType\BuildingListReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BuildingListReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BuildingListReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
