<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Temperature ServiceType
 * @subpackage Services
 */
class Temperature extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TemperatureAlarm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TemperatureAlarm $parameters
     * @return \StructType\TemperatureAlarmResponse|bool
     */
    public function TemperatureAlarm(\StructType\TemperatureAlarm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TemperatureAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TemperatureAlarmResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
