<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ignition ServiceType
 * @subpackage Services
 */
class Ignition extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IgnitionAlarmReturnObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IgnitionAlarmReturnObject $parameters
     * @return \StructType\IgnitionAlarmReturnObjectResponse|bool
     */
    public function IgnitionAlarmReturnObject(\StructType\IgnitionAlarmReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IgnitionAlarmReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IgnitionDurationReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IgnitionDurationReport $parameters
     * @return \StructType\IgnitionDurationReportResponse|bool
     */
    public function IgnitionDurationReport(\StructType\IgnitionDurationReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IgnitionDurationReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IgnitionAlarmReturnObjectResponse|\StructType\IgnitionDurationReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
