<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Technical ServiceType
 * @subpackage Services
 */
class Technical extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TechnicalPerformanceReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TechnicalPerformanceReport $parameters
     * @return \StructType\TechnicalPerformanceReportResponse|bool
     */
    public function TechnicalPerformanceReport(\StructType\TechnicalPerformanceReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TechnicalPerformanceReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TechnicalPerformanceReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
