<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Motion ServiceType
 * @subpackage Services
 */
class Motion extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MotionAlarm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MotionAlarm $parameters
     * @return \StructType\MotionAlarmResponse|bool
     */
    public function MotionAlarm(\StructType\MotionAlarm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MotionAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MotionAlarmResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
