<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Fuel ServiceType
 * @subpackage Services
 */
class Fuel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FuelConsumptionReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FuelConsumptionReport $parameters
     * @return \StructType\FuelConsumptionReportResponse|bool
     */
    public function FuelConsumptionReport(\StructType\FuelConsumptionReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FuelConsumptionReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FuelConsumptionReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
