<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNearestNodes StructType
 * @subpackage Structs
 */
class GetNearestNodes extends AbstractStructBase
{
    /**
     * The LongitudeX
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LongitudeX;
    /**
     * The LatitudeY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LatitudeY;
    /**
     * The Radius
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Radius;
    /**
     * The DisplayDurationInMinutes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DisplayDurationInMinutes;
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The PIN1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN1;
    /**
     * The PIN2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN2;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The Locale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Locale;
    /**
     * Constructor method for GetNearestNodes
     * @uses GetNearestNodes::setLongitudeX()
     * @uses GetNearestNodes::setLatitudeY()
     * @uses GetNearestNodes::setRadius()
     * @uses GetNearestNodes::setDisplayDurationInMinutes()
     * @uses GetNearestNodes::setUsername()
     * @uses GetNearestNodes::setPIN1()
     * @uses GetNearestNodes::setPIN2()
     * @uses GetNearestNodes::setLanguage()
     * @uses GetNearestNodes::setLocale()
     * @param float $longitudeX
     * @param float $latitudeY
     * @param int $radius
     * @param int $displayDurationInMinutes
     * @param string $username
     * @param string $pIN1
     * @param string $pIN2
     * @param string $language
     * @param string $locale
     */
    public function __construct($longitudeX = null, $latitudeY = null, $radius = null, $displayDurationInMinutes = null, $username = null, $pIN1 = null, $pIN2 = null, $language = null, $locale = null)
    {
        $this
            ->setLongitudeX($longitudeX)
            ->setLatitudeY($latitudeY)
            ->setRadius($radius)
            ->setDisplayDurationInMinutes($displayDurationInMinutes)
            ->setUsername($username)
            ->setPIN1($pIN1)
            ->setPIN2($pIN2)
            ->setLanguage($language)
            ->setLocale($locale);
    }
    /**
     * Get LongitudeX value
     * @return float
     */
    public function getLongitudeX()
    {
        return $this->LongitudeX;
    }
    /**
     * Set LongitudeX value
     * @param float $longitudeX
     * @return \StructType\GetNearestNodes
     */
    public function setLongitudeX($longitudeX = null)
    {
        // validation for constraint: float
        if (!is_null($longitudeX) && !(is_float($longitudeX) || is_numeric($longitudeX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitudeX, true), gettype($longitudeX)), __LINE__);
        }
        $this->LongitudeX = $longitudeX;
        return $this;
    }
    /**
     * Get LatitudeY value
     * @return float
     */
    public function getLatitudeY()
    {
        return $this->LatitudeY;
    }
    /**
     * Set LatitudeY value
     * @param float $latitudeY
     * @return \StructType\GetNearestNodes
     */
    public function setLatitudeY($latitudeY = null)
    {
        // validation for constraint: float
        if (!is_null($latitudeY) && !(is_float($latitudeY) || is_numeric($latitudeY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitudeY, true), gettype($latitudeY)), __LINE__);
        }
        $this->LatitudeY = $latitudeY;
        return $this;
    }
    /**
     * Get Radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param int $radius
     * @return \StructType\GetNearestNodes
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !(is_int($radius) || ctype_digit($radius))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($radius, true), gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get DisplayDurationInMinutes value
     * @return int
     */
    public function getDisplayDurationInMinutes()
    {
        return $this->DisplayDurationInMinutes;
    }
    /**
     * Set DisplayDurationInMinutes value
     * @param int $displayDurationInMinutes
     * @return \StructType\GetNearestNodes
     */
    public function setDisplayDurationInMinutes($displayDurationInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($displayDurationInMinutes) && !(is_int($displayDurationInMinutes) || ctype_digit($displayDurationInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayDurationInMinutes, true), gettype($displayDurationInMinutes)), __LINE__);
        }
        $this->DisplayDurationInMinutes = $displayDurationInMinutes;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\GetNearestNodes
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get PIN1 value
     * @return string|null
     */
    public function getPIN1()
    {
        return $this->PIN1;
    }
    /**
     * Set PIN1 value
     * @param string $pIN1
     * @return \StructType\GetNearestNodes
     */
    public function setPIN1($pIN1 = null)
    {
        // validation for constraint: string
        if (!is_null($pIN1) && !is_string($pIN1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN1, true), gettype($pIN1)), __LINE__);
        }
        $this->PIN1 = $pIN1;
        return $this;
    }
    /**
     * Get PIN2 value
     * @return string|null
     */
    public function getPIN2()
    {
        return $this->PIN2;
    }
    /**
     * Set PIN2 value
     * @param string $pIN2
     * @return \StructType\GetNearestNodes
     */
    public function setPIN2($pIN2 = null)
    {
        // validation for constraint: string
        if (!is_null($pIN2) && !is_string($pIN2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN2, true), gettype($pIN2)), __LINE__);
        }
        $this->PIN2 = $pIN2;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\GetNearestNodes
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param string $locale
     * @return \StructType\GetNearestNodes
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: string
        if (!is_null($locale) && !is_string($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locale, true), gettype($locale)), __LINE__);
        }
        $this->Locale = $locale;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetNearestNodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
