<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Total ServiceType
 * @subpackage Services
 */
class Total extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TotalPauseTime
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TotalPauseTime $parameters
     * @return \StructType\TotalPauseTimeResponse|bool
     */
    public function TotalPauseTime(\StructType\TotalPauseTime $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TotalPauseTime($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TotalIdlingTime
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TotalIdlingTime $parameters
     * @return \StructType\TotalIdlingTimeResponse|bool
     */
    public function TotalIdlingTime(\StructType\TotalIdlingTime $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TotalIdlingTime($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TotalRunningTime
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TotalRunningTime $parameters
     * @return \StructType\TotalRunningTimeResponse|bool
     */
    public function TotalRunningTime(\StructType\TotalRunningTime $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TotalRunningTime($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TotalIdlingTimeResponse|\StructType\TotalPauseTimeResponse|\StructType\TotalRunningTimeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
