<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Idling ServiceType
 * @subpackage Services
 */
class Idling extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IdlingDurationReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IdlingDurationReport $parameters
     * @return \StructType\IdlingDurationReportResponse|bool
     */
    public function IdlingDurationReport(\StructType\IdlingDurationReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IdlingDurationReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IdlingAlarm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IdlingAlarm $parameters
     * @return \StructType\IdlingAlarmResponse|bool
     */
    public function IdlingAlarm(\StructType\IdlingAlarm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IdlingAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IdlingAlarmResponse|\StructType\IdlingDurationReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
