<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Speed ServiceType
 * @subpackage Services
 */
class Speed extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SpeedReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SpeedReport $parameters
     * @return \StructType\SpeedReportResponse|bool
     */
    public function SpeedReport(\StructType\SpeedReport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SpeedReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SpeedAlarm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SpeedAlarm $parameters
     * @return \StructType\SpeedAlarmResponse|bool
     */
    public function SpeedAlarm(\StructType\SpeedAlarm $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SpeedAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SpeedAlarmReturnObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SpeedAlarmReturnObject $parameters
     * @return \StructType\SpeedAlarmReturnObjectResponse|bool
     */
    public function SpeedAlarmReturnObject(\StructType\SpeedAlarmReturnObject $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SpeedAlarmReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SpeedAlarmV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SpeedAlarmV2 $parameters
     * @return \StructType\SpeedAlarmV2Response|bool
     */
    public function SpeedAlarmV2(\StructType\SpeedAlarmV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SpeedAlarmV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SpeedAlarmResponse|\StructType\SpeedAlarmReturnObjectResponse|\StructType\SpeedAlarmV2Response|\StructType\SpeedReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
