<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Door ServiceType
 * @subpackage Services
 */
class Door extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DoorAlarm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoorAlarm $parameters
     * @return \StructType\DoorAlarmResponse|bool
     */
    public function DoorAlarm(\StructType\DoorAlarm $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DoorAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DoorAlarm2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DoorAlarm2 $parameters
     * @return \StructType\DoorAlarm2Response|bool
     */
    public function DoorAlarm2(\StructType\DoorAlarm2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DoorAlarm2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DoorAlarm2Response|\StructType\DoorAlarmResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
