<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleProgramReport StructType
 * @subpackage Structs
 */
class VehicleProgramReport extends AbstractStructBase
{
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The PIN1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN1;
    /**
     * The PIN2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN2;
    /**
     * The Node
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Node;
    /**
     * The Group
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Group;
    /**
     * The chkAllVehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $chkAllVehicles;
    /**
     * The Compress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Compress;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The ProgrammingVehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgrammingVehicles;
    /**
     * Constructor method for VehicleProgramReport
     * @uses VehicleProgramReport::setUsername()
     * @uses VehicleProgramReport::setPIN1()
     * @uses VehicleProgramReport::setPIN2()
     * @uses VehicleProgramReport::setNode()
     * @uses VehicleProgramReport::setGroup()
     * @uses VehicleProgramReport::setChkAllVehicles()
     * @uses VehicleProgramReport::setCompress()
     * @uses VehicleProgramReport::setLanguage()
     * @uses VehicleProgramReport::setProgrammingVehicles()
     * @param string $username
     * @param string $pIN1
     * @param string $pIN2
     * @param string $node
     * @param string $group
     * @param string $chkAllVehicles
     * @param string $compress
     * @param string $language
     * @param string $programmingVehicles
     */
    public function __construct($username = null, $pIN1 = null, $pIN2 = null, $node = null, $group = null, $chkAllVehicles = null, $compress = null, $language = null, $programmingVehicles = null)
    {
        $this
            ->setUsername($username)
            ->setPIN1($pIN1)
            ->setPIN2($pIN2)
            ->setNode($node)
            ->setGroup($group)
            ->setChkAllVehicles($chkAllVehicles)
            ->setCompress($compress)
            ->setLanguage($language)
            ->setProgrammingVehicles($programmingVehicles);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\VehicleProgramReport
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get PIN1 value
     * @return string|null
     */
    public function getPIN1()
    {
        return $this->PIN1;
    }
    /**
     * Set PIN1 value
     * @param string $pIN1
     * @return \StructType\VehicleProgramReport
     */
    public function setPIN1($pIN1 = null)
    {
        // validation for constraint: string
        if (!is_null($pIN1) && !is_string($pIN1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pIN1)), __LINE__);
        }
        $this->PIN1 = $pIN1;
        return $this;
    }
    /**
     * Get PIN2 value
     * @return string|null
     */
    public function getPIN2()
    {
        return $this->PIN2;
    }
    /**
     * Set PIN2 value
     * @param string $pIN2
     * @return \StructType\VehicleProgramReport
     */
    public function setPIN2($pIN2 = null)
    {
        // validation for constraint: string
        if (!is_null($pIN2) && !is_string($pIN2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pIN2)), __LINE__);
        }
        $this->PIN2 = $pIN2;
        return $this;
    }
    /**
     * Get Node value
     * @return string|null
     */
    public function getNode()
    {
        return $this->Node;
    }
    /**
     * Set Node value
     * @param string $node
     * @return \StructType\VehicleProgramReport
     */
    public function setNode($node = null)
    {
        // validation for constraint: string
        if (!is_null($node) && !is_string($node)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($node)), __LINE__);
        }
        $this->Node = $node;
        return $this;
    }
    /**
     * Get Group value
     * @return string|null
     */
    public function getGroup()
    {
        return $this->Group;
    }
    /**
     * Set Group value
     * @param string $group
     * @return \StructType\VehicleProgramReport
     */
    public function setGroup($group = null)
    {
        // validation for constraint: string
        if (!is_null($group) && !is_string($group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($group)), __LINE__);
        }
        $this->Group = $group;
        return $this;
    }
    /**
     * Get chkAllVehicles value
     * @return string|null
     */
    public function getChkAllVehicles()
    {
        return $this->chkAllVehicles;
    }
    /**
     * Set chkAllVehicles value
     * @param string $chkAllVehicles
     * @return \StructType\VehicleProgramReport
     */
    public function setChkAllVehicles($chkAllVehicles = null)
    {
        // validation for constraint: string
        if (!is_null($chkAllVehicles) && !is_string($chkAllVehicles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chkAllVehicles)), __LINE__);
        }
        $this->chkAllVehicles = $chkAllVehicles;
        return $this;
    }
    /**
     * Get Compress value
     * @return string|null
     */
    public function getCompress()
    {
        return $this->Compress;
    }
    /**
     * Set Compress value
     * @param string $compress
     * @return \StructType\VehicleProgramReport
     */
    public function setCompress($compress = null)
    {
        // validation for constraint: string
        if (!is_null($compress) && !is_string($compress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($compress)), __LINE__);
        }
        $this->Compress = $compress;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\VehicleProgramReport
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get ProgrammingVehicles value
     * @return string|null
     */
    public function getProgrammingVehicles()
    {
        return $this->ProgrammingVehicles;
    }
    /**
     * Set ProgrammingVehicles value
     * @param string $programmingVehicles
     * @return \StructType\VehicleProgramReport
     */
    public function setProgrammingVehicles($programmingVehicles = null)
    {
        // validation for constraint: string
        if (!is_null($programmingVehicles) && !is_string($programmingVehicles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programmingVehicles)), __LINE__);
        }
        $this->ProgrammingVehicles = $programmingVehicles;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleProgramReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
