<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pause ServiceType
 * @subpackage Services
 */
class Pause extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PauseDurationReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PauseDurationReport $parameters
     * @return \StructType\PauseDurationReportResponse|bool
     */
    public function PauseDurationReport(\StructType\PauseDurationReport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PauseDurationReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PauseDurationReport2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PauseDurationReport2 $parameters
     * @return \StructType\PauseDurationReport2Response|bool
     */
    public function PauseDurationReport2(\StructType\PauseDurationReport2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PauseDurationReport2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PauseAlarm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PauseAlarm $parameters
     * @return \StructType\PauseAlarmResponse|bool
     */
    public function PauseAlarm(\StructType\PauseAlarm $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PauseAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PauseAlarm2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PauseAlarm2 $parameters
     * @return \StructType\PauseAlarm2Response|bool
     */
    public function PauseAlarm2(\StructType\PauseAlarm2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PauseAlarm2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PauseAlarm2Response|\StructType\PauseAlarmResponse|\StructType\PauseDurationReport2Response|\StructType\PauseDurationReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
