<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetLocalDateTime
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLocalDateTime $parameters
     * @return \StructType\GetLocalDateTimeResponse|bool
     */
    public function GetLocalDateTime(\StructType\GetLocalDateTime $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLocalDateTime($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNodes $parameters
     * @return \StructType\GetNodesResponse|bool
     */
    public function GetNodes(\StructType\GetNodes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGroups $parameters
     * @return \StructType\GetGroupsResponse|bool
     */
    public function GetGroups(\StructType\GetGroups $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNearestNodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNearestNodes $parameters
     * @return \StructType\GetNearestNodesResponse|bool
     */
    public function GetNearestNodes(\StructType\GetNearestNodes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNearestNodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIMSIList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIMSIList $parameters
     * @return \StructType\GetIMSIListResponse|bool
     */
    public function GetIMSIList(\StructType\GetIMSIList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetIMSIList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLicensePlateFromNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLicensePlateFromNode $parameters
     * @return \StructType\GetLicensePlateFromNodeResponse|bool
     */
    public function GetLicensePlateFromNode(\StructType\GetLicensePlateFromNode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLicensePlateFromNode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNodeFromLicensePlate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNodeFromLicensePlate $parameters
     * @return \StructType\GetNodeFromLicensePlateResponse|bool
     */
    public function GetNodeFromLicensePlate(\StructType\GetNodeFromLicensePlate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNodeFromLicensePlate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLicensePlateNodeMappings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLicensePlateNodeMappings $parameters
     * @return \StructType\GetLicensePlateNodeMappingsResponse|bool
     */
    public function GetLicensePlateNodeMappings(\StructType\GetLicensePlateNodeMappings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLicensePlateNodeMappings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDriverFromNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriverFromNode $parameters
     * @return \StructType\GetDriverFromNodeResponse|bool
     */
    public function GetDriverFromNode(\StructType\GetDriverFromNode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDriverFromNode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNodeFromDriver
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNodeFromDriver $parameters
     * @return \StructType\GetNodeFromDriverResponse|bool
     */
    public function GetNodeFromDriver(\StructType\GetNodeFromDriver $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNodeFromDriver($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDriverNodeMappings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriverNodeMappings $parameters
     * @return \StructType\GetDriverNodeMappingsResponse|bool
     */
    public function GetDriverNodeMappings(\StructType\GetDriverNodeMappings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDriverNodeMappings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCrewFromNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCrewFromNode $parameters
     * @return \StructType\GetCrewFromNodeResponse|bool
     */
    public function GetCrewFromNode(\StructType\GetCrewFromNode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCrewFromNode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNodeFromCrew
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNodeFromCrew $parameters
     * @return \StructType\GetNodeFromCrewResponse|bool
     */
    public function GetNodeFromCrew(\StructType\GetNodeFromCrew $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNodeFromCrew($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleInfo $parameters
     * @return \StructType\GetVehicleInfoResponse|bool
     */
    public function GetVehicleInfo(\StructType\GetVehicleInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehicleInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDriverInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDriverInfo $parameters
     * @return \StructType\GetDriverInfoResponse|bool
     */
    public function GetDriverInfo(\StructType\GetDriverInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDriverInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleStatusByNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleStatusByNode $parameters
     * @return \StructType\GetVehicleStatusByNodeResponse|bool
     */
    public function GetVehicleStatusByNode(\StructType\GetVehicleStatusByNode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehicleStatusByNode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleStatus $parameters
     * @return \StructType\GetVehicleStatusResponse|bool
     */
    public function GetVehicleStatus(\StructType\GetVehicleStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehicleStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleStatusReturnList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleStatusReturnList $parameters
     * @return \StructType\GetVehicleStatusReturnListResponse|bool
     */
    public function GetVehicleStatusReturnList(\StructType\GetVehicleStatusReturnList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehicleStatusReturnList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleStatusWithCourse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleStatusWithCourse $parameters
     * @return \StructType\GetVehicleStatusWithCourseResponse|bool
     */
    public function GetVehicleStatusWithCourse(\StructType\GetVehicleStatusWithCourse $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehicleStatusWithCourse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleStatusV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleStatusV3 $parameters
     * @return \StructType\GetVehicleStatusV3Response|bool
     */
    public function GetVehicleStatusV3(\StructType\GetVehicleStatusV3 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehicleStatusV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleStatusByNodeV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleStatusByNodeV3 $parameters
     * @return \StructType\GetVehicleStatusByNodeV3Response|bool
     */
    public function GetVehicleStatusByNodeV3(\StructType\GetVehicleStatusByNodeV3 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehicleStatusByNodeV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleStatusV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleStatusV2 $parameters
     * @return \StructType\GetVehicleStatusV2Response|bool
     */
    public function GetVehicleStatusV2(\StructType\GetVehicleStatusV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehicleStatusV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleStatusJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleStatusJSON $parameters
     * @return \StructType\GetVehicleStatusJSONResponse|bool
     */
    public function GetVehicleStatusJSON(\StructType\GetVehicleStatusJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehicleStatusJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleAlarmStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleAlarmStatus $parameters
     * @return \StructType\GetVehicleAlarmStatusResponse|bool
     */
    public function GetVehicleAlarmStatus(\StructType\GetVehicleAlarmStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehicleAlarmStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleAlarmStatusV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVehicleAlarmStatusV2 $parameters
     * @return \StructType\GetVehicleAlarmStatusV2Response|bool
     */
    public function GetVehicleAlarmStatusV2(\StructType\GetVehicleAlarmStatusV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehicleAlarmStatusV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCrewFromNodeResponse|\StructType\GetDriverFromNodeResponse|\StructType\GetDriverInfoResponse|\StructType\GetDriverNodeMappingsResponse|\StructType\GetGroupsResponse|\StructType\GetIMSIListResponse|\StructType\GetLicensePlateFromNodeResponse|\StructType\GetLicensePlateNodeMappingsResponse|\StructType\GetLocalDateTimeResponse|\StructType\GetNearestNodesResponse|\StructType\GetNodeFromCrewResponse|\StructType\GetNodeFromDriverResponse|\StructType\GetNodeFromLicensePlateResponse|\StructType\GetNodesResponse|\StructType\GetVehicleAlarmStatusResponse|\StructType\GetVehicleAlarmStatusV2Response|\StructType\GetVehicleInfoResponse|\StructType\GetVehicleStatusByNodeResponse|\StructType\GetVehicleStatusByNodeV3Response|\StructType\GetVehicleStatusJSONResponse|\StructType\GetVehicleStatusResponse|\StructType\GetVehicleStatusReturnListResponse|\StructType\GetVehicleStatusV2Response|\StructType\GetVehicleStatusV3Response|\StructType\GetVehicleStatusWithCourseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
