<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Region ServiceType
 * @subpackage Services
 */
class Region extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RegionAlarm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegionAlarm $parameters
     * @return \StructType\RegionAlarmResponse|bool
     */
    public function RegionAlarm(\StructType\RegionAlarm $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RegionAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegionTravelReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegionTravelReport $parameters
     * @return \StructType\RegionTravelReportResponse|bool
     */
    public function RegionTravelReport(\StructType\RegionTravelReport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RegionTravelReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RegionAlarmResponse|\StructType\RegionTravelReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
