<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Vehicle ServiceType
 * @subpackage Services
 */
class Vehicle extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named VehicleProgramReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleProgramReport $parameters
     * @return \StructType\VehicleProgramReportResponse|bool
     */
    public function VehicleProgramReport(\StructType\VehicleProgramReport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VehicleProgramReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleOperatingReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleOperatingReport $parameters
     * @return \StructType\VehicleOperatingReportResponse|bool
     */
    public function VehicleOperatingReport(\StructType\VehicleOperatingReport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VehicleOperatingReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleOperatingReport2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleOperatingReport2 $parameters
     * @return \StructType\VehicleOperatingReport2Response|bool
     */
    public function VehicleOperatingReport2(\StructType\VehicleOperatingReport2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VehicleOperatingReport2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleDistanceReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleDistanceReport $parameters
     * @return \StructType\VehicleDistanceReportResponse|bool
     */
    public function VehicleDistanceReport(\StructType\VehicleDistanceReport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VehicleDistanceReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleDistanceReport2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleDistanceReport2 $parameters
     * @return \StructType\VehicleDistanceReport2Response|bool
     */
    public function VehicleDistanceReport2(\StructType\VehicleDistanceReport2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VehicleDistanceReport2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehiclePrivateUsageReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehiclePrivateUsageReport $parameters
     * @return \StructType\VehiclePrivateUsageReportResponse|bool
     */
    public function VehiclePrivateUsageReport(\StructType\VehiclePrivateUsageReport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VehiclePrivateUsageReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleLastStateReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleLastStateReport $parameters
     * @return \StructType\VehicleLastStateReportResponse|bool
     */
    public function VehicleLastStateReport(\StructType\VehicleLastStateReport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VehicleLastStateReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VehicleLastStateReport2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleLastStateReport2 $parameters
     * @return \StructType\VehicleLastStateReport2Response|bool
     */
    public function VehicleLastStateReport2(\StructType\VehicleLastStateReport2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VehicleLastStateReport2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VehicleDistanceReport2Response|\StructType\VehicleDistanceReportResponse|\StructType\VehicleLastStateReport2Response|\StructType\VehicleLastStateReportResponse|\StructType\VehicleOperatingReport2Response|\StructType\VehicleOperatingReportResponse|\StructType\VehiclePrivateUsageReportResponse|\StructType\VehicleProgramReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
