<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Can ServiceType
 * @subpackage Services
 */
class Can extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CanBusOBDFuelInfoReport
     * Meta information extracted from the WSDL
     * - documentation: Canbus/OBD gelen yakit bilgisini gosterir. Aractan yakit seviye bilgisi alabilmek icin bu verinin Canbus ya da OBD uzerinden gonderilmesi gerekmektedir. - Shows fuel information which comes from Canbus/Obd. This data must be sent via
     * CANbus or OBD to obtain fuel level information from the vehicle. | Canbus/OBD gelen yakit bilgisini gosterir. Aractan yakit seviye bilgisi alabilmek icin bu verinin Canbus ya da OBD uzerinden gonderilmesi gerekmektedir. - Shows fuel information which
     * comes from Canbus/Obd. This data must be sent via CANbus or OBD to obtain fuel level information from the vehicle. | Canbus/OBD gelen yakit bilgisini gosterir. Aractan yakit seviye bilgisi alabilmek icin bu verinin Canbus ya da OBD uzerinden
     * gonderilmesi gerekmektedir. - Shows fuel information which comes from Canbus/Obd. This data must be sent via CANbus or OBD to obtain fuel level information from the vehicle.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CanBusOBDFuelInfoReport $parameters
     * @return \StructType\CanBusOBDFuelInfoReportResponse|bool
     */
    public function CanBusOBDFuelInfoReport(\StructType\CanBusOBDFuelInfoReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CanBusOBDFuelInfoReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CanBusOBDFuelInfoReportReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Canbus/OBD gelen yakit bilgisini gosterir. Aractan yakit seviye bilgisi alabilmek icin bu verinin Canbus ya da OBD uzerinden gonderilmesi gerekmektedir. CanBusOBDFuelInfoReport methodundan farkli olarak sonucu XmlDocument tipinde
     * dondurur.- Shows fuel information which comes from Canbus/Obd. This data must be sent via CANbus or OBD to obtain fuel level information from the vehicle, returns the result as XmlDocument type. | Canbus/OBD gelen yakit bilgisini gosterir. Aractan
     * yakit seviye bilgisi alabilmek icin bu verinin Canbus ya da OBD uzerinden gonderilmesi gerekmektedir. CanBusOBDFuelInfoReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur.- Shows fuel information which comes from Canbus/Obd. This
     * data must be sent via CANbus or OBD to obtain fuel level information from the vehicle, returns the result as XmlDocument type. | Canbus/OBD gelen yakit bilgisini gosterir. Aractan yakit seviye bilgisi alabilmek icin bu verinin Canbus ya da OBD
     * uzerinden gonderilmesi gerekmektedir. CanBusOBDFuelInfoReport methodundan farkli olarak sonucu XmlDocument tipinde dondurur.- Shows fuel information which comes from Canbus/Obd. This data must be sent via CANbus or OBD to obtain fuel level
     * information from the vehicle, returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CanBusOBDFuelInfoReportReturnObject $parameters
     * @return \StructType\CanBusOBDFuelInfoReportReturnObjectResponse|bool
     */
    public function CanBusOBDFuelInfoReportReturnObject(\StructType\CanBusOBDFuelInfoReportReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CanBusOBDFuelInfoReportReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CanBusOBDOdometerInfoReport
     * Meta information extracted from the WSDL
     * - documentation: Canbus ya da OBD mesafe listesini olusturur. Aractan odometre ( mesafe sayaci ) bilgisini alabilmek icin bu verinin Canbus ya da OBD uzerinden gonderilmesi gerekmektedir. - It generates odometer information which comes from Canbus or
     * OBD.This data must be sent via Canbus or OBD in order to obtain the odometer(distance meter) information from the vehicle. | Canbus ya da OBD mesafe listesini olusturur. Aractan odometre ( mesafe sayaci ) bilgisini alabilmek icin bu verinin Canbus ya
     * da OBD uzerinden gonderilmesi gerekmektedir. - It generates odometer information which comes from Canbus or OBD.This data must be sent via Canbus or OBD in order to obtain the odometer(distance meter) information from the vehicle. | Canbus ya da OBD
     * mesafe listesini olusturur. Aractan odometre ( mesafe sayaci ) bilgisini alabilmek icin bu verinin Canbus ya da OBD uzerinden gonderilmesi gerekmektedir. - It generates odometer information which comes from Canbus or OBD.This data must be sent via
     * Canbus or OBD in order to obtain the odometer(distance meter) information from the vehicle.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CanBusOBDOdometerInfoReport $parameters
     * @return \StructType\CanBusOBDOdometerInfoReportResponse|bool
     */
    public function CanBusOBDOdometerInfoReport(\StructType\CanBusOBDOdometerInfoReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CanBusOBDOdometerInfoReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CanBusOBDOdometerInfoReportReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Canbus ya da OBD mesafe listesini olusturur. Aractan odometre ( mesafe sayaci ) bilgisini alabilmek icin bu verinin Canbus ya da OBD uzerinden gonderilmesi gerekmektedir. CanBusOBDOdometerInfoReport methodundan farkli olarak sonucu
     * XmlDocument tipinde dondurur. - It generates odometer information which comes from Canbus or OBD.This data must be sent via Canbus or OBD in order to obtain the odometer(distance meter) information from the vehicle, returns the result as XmlDocument
     * type. | Canbus ya da OBD mesafe listesini olusturur. Aractan odometre ( mesafe sayaci ) bilgisini alabilmek icin bu verinin Canbus ya da OBD uzerinden gonderilmesi gerekmektedir. CanBusOBDOdometerInfoReport methodundan farkli olarak sonucu
     * XmlDocument tipinde dondurur. - It generates odometer information which comes from Canbus or OBD.This data must be sent via Canbus or OBD in order to obtain the odometer(distance meter) information from the vehicle, returns the result as XmlDocument
     * type. | Canbus ya da OBD mesafe listesini olusturur. Aractan odometre ( mesafe sayaci ) bilgisini alabilmek icin bu verinin Canbus ya da OBD uzerinden gonderilmesi gerekmektedir. CanBusOBDOdometerInfoReport methodundan farkli olarak sonucu
     * XmlDocument tipinde dondurur. - It generates odometer information which comes from Canbus or OBD.This data must be sent via Canbus or OBD in order to obtain the odometer(distance meter) information from the vehicle, returns the result as XmlDocument
     * type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CanBusOBDOdometerInfoReportReturnObject $parameters
     * @return \StructType\CanBusOBDOdometerInfoReportReturnObjectResponse|bool
     */
    public function CanBusOBDOdometerInfoReportReturnObject(\StructType\CanBusOBDOdometerInfoReportReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CanBusOBDOdometerInfoReportReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CanBusOBDGeneralReport
     * Meta information extracted from the WSDL
     * - documentation: Canbus/OBD verilerinden olusan genel rapordur. OBD ve Canbus; arac ici Network bilgisinin genel adlaridir. CanBus ve OBD ile Arac Kontrol unitesi (ECU)’ne baglanti yaparak aractan veri alinmaktadir. Bu metot ile ECU’dan gelen
     * veriler raporlanir. - General description of Canbus / OBD data. OBD and Canbus; general vehicle network information Names on vehicle. CanBus and OBD are connected to the Vehicle Control Unit (ECU) to receive data from the vehicle. This method reports
     * data from the ECU. | Canbus/OBD verilerinden olusan genel rapordur. OBD ve Canbus; arac ici Network bilgisinin genel adlaridir. CanBus ve OBD ile Arac Kontrol unitesi (ECU)’ne baglanti yaparak aractan veri alinmaktadir. Bu metot ile ECU’dan gelen
     * veriler raporlanir. - General description of Canbus / OBD data. OBD and Canbus; general vehicle network information Names on vehicle. CanBus and OBD are connected to the Vehicle Control Unit (ECU) to receive data from the vehicle. This method reports
     * data from the ECU. | Canbus/OBD verilerinden olusan genel rapordur. OBD ve Canbus; arac ici Network bilgisinin genel adlaridir. CanBus ve OBD ile Arac Kontrol unitesi (ECU)’ne baglanti yaparak aractan veri alinmaktadir. Bu metot ile ECU’dan gelen
     * veriler raporlanir. - General description of Canbus / OBD data. OBD and Canbus; general vehicle network information Names on vehicle. CanBus and OBD are connected to the Vehicle Control Unit (ECU) to receive data from the vehicle. This method reports
     * data from the ECU.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CanBusOBDGeneralReport $parameters
     * @return \StructType\CanBusOBDGeneralReportResponse|bool
     */
    public function CanBusOBDGeneralReport(\StructType\CanBusOBDGeneralReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CanBusOBDGeneralReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CanBusOBDGeneralReportReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Canbus/OBD verilerinden olusan genel rapordur. OBD ve Canbus; arac ici Network bilgisinin genel adlaridir. CanBus ve OBD ile Arac Kontrol unitesi (ECU)’ne baglanti yaparak aractan veri alinmaktadir. Bu metot ile ECU’dan gelen
     * veriler raporlanir. - General description of Canbus / OBD data. OBD and Canbus; general vehicle network information Names on vehicle. CanBus and OBD are connected to the Vehicle Control Unit (ECU) to receive data from the vehicle. This method reports
     * data from the ECU. | Canbus/OBD verilerinden olusan genel rapordur. OBD ve Canbus; arac ici Network bilgisinin genel adlaridir. CanBus ve OBD ile Arac Kontrol unitesi (ECU)’ne baglanti yaparak aractan veri alinmaktadir. Bu metot ile ECU’dan gelen
     * veriler raporlanir. - General description of Canbus / OBD data. OBD and Canbus; general vehicle network information Names on vehicle. CanBus and OBD are connected to the Vehicle Control Unit (ECU) to receive data from the vehicle. This method reports
     * data from the ECU. | Canbus/OBD verilerinden olusan genel rapordur. OBD ve Canbus; arac ici Network bilgisinin genel adlaridir. CanBus ve OBD ile Arac Kontrol unitesi (ECU)’ne baglanti yaparak aractan veri alinmaktadir. Bu metot ile ECU’dan gelen
     * veriler raporlanir. - General description of Canbus / OBD data. OBD and Canbus; general vehicle network information Names on vehicle. CanBus and OBD are connected to the Vehicle Control Unit (ECU) to receive data from the vehicle. This method reports
     * data from the ECU.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CanBusOBDGeneralReportReturnObject $parameters
     * @return \StructType\CanBusOBDGeneralReportReturnObjectResponse|bool
     */
    public function CanBusOBDGeneralReportReturnObject(\StructType\CanBusOBDGeneralReportReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CanBusOBDGeneralReportReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CanBusFuelInfo
     * Meta information extracted from the WSDL
     * - documentation: Arac yakit seviyesi artis/azalis bilgisi listesini olusturur. Aractan yakit seviye artisi/azalisi bilgisi alabilmek icin bu verinin Canbus uzerinden gonderilmesi gerekmektedir. - It generates vehicle fuel increase/decrase level
     * information. In order to extract this report, fuel increase/decrease level information should come from vehicle with Canbus. | Arac yakit seviyesi artis/azalis bilgisi listesini olusturur. Aractan yakit seviye artisi/azalisi bilgisi alabilmek icin bu
     * verinin Canbus uzerinden gonderilmesi gerekmektedir. - It generates vehicle fuel increase/decrase level information. In order to extract this report, fuel increase/decrease level information should come from vehicle with Canbus. | Arac yakit seviyesi
     * artis/azalis bilgisi listesini olusturur. Aractan yakit seviye artisi/azalisi bilgisi alabilmek icin bu verinin Canbus uzerinden gonderilmesi gerekmektedir. - It generates vehicle fuel increase/decrase level information. In order to extract this
     * report, fuel increase/decrease level information should come from vehicle with Canbus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CanBusFuelInfo $parameters
     * @return \StructType\CanBusFuelInfoResponse|bool
     */
    public function CanBusFuelInfo(\StructType\CanBusFuelInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CanBusFuelInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CanBusFuelInfoReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Arac yakit seviye bilgisi listesini olusturur. Aractan yakit seviye bilgisi alabilmek icin bu verinin Canbus uzerinden gonderilmesi gerekmektedir. CanBusFuelInfo methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It
     * generates vehicle fuel level information. In order to extract this report, fuel level information should come from vehicle with Canbus, returns the result as XmlDocument type. | Arac yakit seviye bilgisi listesini olusturur. Aractan yakit seviye
     * bilgisi alabilmek icin bu verinin Canbus uzerinden gonderilmesi gerekmektedir. CanBusFuelInfo methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It generates vehicle fuel level information. In order to extract this report, fuel level
     * information should come from vehicle with Canbus, returns the result as XmlDocument type. | Arac yakit seviye bilgisi listesini olusturur. Aractan yakit seviye bilgisi alabilmek icin bu verinin Canbus uzerinden gonderilmesi gerekmektedir.
     * CanBusFuelInfo methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It generates vehicle fuel level information. In order to extract this report, fuel level information should come from vehicle with Canbus, returns the result as
     * XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CanBusFuelInfoReturnObject $parameters
     * @return \StructType\CanBusFuelInfoReturnObjectResponse|bool
     */
    public function CanBusFuelInfoReturnObject(\StructType\CanBusFuelInfoReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CanBusFuelInfoReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CanBusEmptyInfo
     * Meta information extracted from the WSDL
     * - documentation: Aractan gelen CanBus verilerini listeler. - It generates CanBus information | Aractan gelen CanBus verilerini listeler. - It generates CanBus information | Aractan gelen CanBus verilerini listeler. - It generates CanBus information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CanBusEmptyInfo $parameters
     * @return \StructType\CanBusEmptyInfoResponse|bool
     */
    public function CanBusEmptyInfo(\StructType\CanBusEmptyInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CanBusEmptyInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CanBusEmptyInfoReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Aractan gelen CanBus verilerini listeler. CanBusEmptyInfo methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It generates CanBus information, returns the result as XmlDocument type. | Aractan gelen CanBus verilerini
     * listeler. CanBusEmptyInfo methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - It generates CanBus information, returns the result as XmlDocument type. | Aractan gelen CanBus verilerini listeler. CanBusEmptyInfo methodundan farkli olarak
     * sonucu XmlDocument tipinde dondurur. - It generates CanBus information, returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CanBusEmptyInfoReturnObject $parameters
     * @return \StructType\CanBusEmptyInfoReturnObjectResponse|bool
     */
    public function CanBusEmptyInfoReturnObject(\StructType\CanBusEmptyInfoReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CanBusEmptyInfoReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CanBusEmptyInfoResponse|\StructType\CanBusEmptyInfoReturnObjectResponse|\StructType\CanBusFuelInfoResponse|\StructType\CanBusFuelInfoReturnObjectResponse|\StructType\CanBusOBDFuelInfoReportResponse|\StructType\CanBusOBDFuelInfoReportReturnObjectResponse|\StructType\CanBusOBDGeneralReportResponse|\StructType\CanBusOBDGeneralReportReturnObjectResponse|\StructType\CanBusOBDOdometerInfoReportResponse|\StructType\CanBusOBDOdometerInfoReportReturnObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
