<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PacketTemperature StructType
 * @subpackage Structs
 */
class PacketTemperature extends AbstractStructBase
{
    /**
     * The GMTDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GMTDateTime;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The Altitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Altitude;
    /**
     * The Speed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Speed;
    /**
     * The Node
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Node;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Town
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Town;
    /**
     * The Temperature1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Temperature1;
    /**
     * The Temperature2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Temperature2;
    /**
     * The Temperature3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Temperature3;
    /**
     * The Temperature4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Temperature4;
    /**
     * Constructor method for PacketTemperature
     * @uses PacketTemperature::setGMTDateTime()
     * @uses PacketTemperature::setLatitude()
     * @uses PacketTemperature::setLongitude()
     * @uses PacketTemperature::setAltitude()
     * @uses PacketTemperature::setSpeed()
     * @uses PacketTemperature::setNode()
     * @uses PacketTemperature::setAddress()
     * @uses PacketTemperature::setRegion()
     * @uses PacketTemperature::setCity()
     * @uses PacketTemperature::setTown()
     * @uses PacketTemperature::setTemperature1()
     * @uses PacketTemperature::setTemperature2()
     * @uses PacketTemperature::setTemperature3()
     * @uses PacketTemperature::setTemperature4()
     * @param string $gMTDateTime
     * @param float $latitude
     * @param float $longitude
     * @param int $altitude
     * @param float $speed
     * @param string $node
     * @param string $address
     * @param string $region
     * @param string $city
     * @param string $town
     * @param string $temperature1
     * @param string $temperature2
     * @param string $temperature3
     * @param string $temperature4
     */
    public function __construct($gMTDateTime = null, $latitude = null, $longitude = null, $altitude = null, $speed = null, $node = null, $address = null, $region = null, $city = null, $town = null, $temperature1 = null, $temperature2 = null, $temperature3 = null, $temperature4 = null)
    {
        $this
            ->setGMTDateTime($gMTDateTime)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setAltitude($altitude)
            ->setSpeed($speed)
            ->setNode($node)
            ->setAddress($address)
            ->setRegion($region)
            ->setCity($city)
            ->setTown($town)
            ->setTemperature1($temperature1)
            ->setTemperature2($temperature2)
            ->setTemperature3($temperature3)
            ->setTemperature4($temperature4);
    }
    /**
     * Get GMTDateTime value
     * @return string
     */
    public function getGMTDateTime()
    {
        return $this->GMTDateTime;
    }
    /**
     * Set GMTDateTime value
     * @param string $gMTDateTime
     * @return \StructType\PacketTemperature
     */
    public function setGMTDateTime($gMTDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($gMTDateTime) && !is_string($gMTDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gMTDateTime, true), gettype($gMTDateTime)), __LINE__);
        }
        $this->GMTDateTime = $gMTDateTime;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\PacketTemperature
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\PacketTemperature
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Altitude value
     * @return int
     */
    public function getAltitude()
    {
        return $this->Altitude;
    }
    /**
     * Set Altitude value
     * @param int $altitude
     * @return \StructType\PacketTemperature
     */
    public function setAltitude($altitude = null)
    {
        // validation for constraint: int
        if (!is_null($altitude) && !(is_int($altitude) || ctype_digit($altitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($altitude, true), gettype($altitude)), __LINE__);
        }
        $this->Altitude = $altitude;
        return $this;
    }
    /**
     * Get Speed value
     * @return float
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param float $speed
     * @return \StructType\PacketTemperature
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: float
        if (!is_null($speed) && !(is_float($speed) || is_numeric($speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($speed, true), gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get Node value
     * @return string|null
     */
    public function getNode()
    {
        return $this->Node;
    }
    /**
     * Set Node value
     * @param string $node
     * @return \StructType\PacketTemperature
     */
    public function setNode($node = null)
    {
        // validation for constraint: string
        if (!is_null($node) && !is_string($node)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($node, true), gettype($node)), __LINE__);
        }
        $this->Node = $node;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\PacketTemperature
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param string $region
     * @return \StructType\PacketTemperature
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\PacketTemperature
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->Town;
    }
    /**
     * Set Town value
     * @param string $town
     * @return \StructType\PacketTemperature
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($town, true), gettype($town)), __LINE__);
        }
        $this->Town = $town;
        return $this;
    }
    /**
     * Get Temperature1 value
     * @return string|null
     */
    public function getTemperature1()
    {
        return $this->Temperature1;
    }
    /**
     * Set Temperature1 value
     * @param string $temperature1
     * @return \StructType\PacketTemperature
     */
    public function setTemperature1($temperature1 = null)
    {
        // validation for constraint: string
        if (!is_null($temperature1) && !is_string($temperature1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($temperature1, true), gettype($temperature1)), __LINE__);
        }
        $this->Temperature1 = $temperature1;
        return $this;
    }
    /**
     * Get Temperature2 value
     * @return string|null
     */
    public function getTemperature2()
    {
        return $this->Temperature2;
    }
    /**
     * Set Temperature2 value
     * @param string $temperature2
     * @return \StructType\PacketTemperature
     */
    public function setTemperature2($temperature2 = null)
    {
        // validation for constraint: string
        if (!is_null($temperature2) && !is_string($temperature2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($temperature2, true), gettype($temperature2)), __LINE__);
        }
        $this->Temperature2 = $temperature2;
        return $this;
    }
    /**
     * Get Temperature3 value
     * @return string|null
     */
    public function getTemperature3()
    {
        return $this->Temperature3;
    }
    /**
     * Set Temperature3 value
     * @param string $temperature3
     * @return \StructType\PacketTemperature
     */
    public function setTemperature3($temperature3 = null)
    {
        // validation for constraint: string
        if (!is_null($temperature3) && !is_string($temperature3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($temperature3, true), gettype($temperature3)), __LINE__);
        }
        $this->Temperature3 = $temperature3;
        return $this;
    }
    /**
     * Get Temperature4 value
     * @return string|null
     */
    public function getTemperature4()
    {
        return $this->Temperature4;
    }
    /**
     * Set Temperature4 value
     * @param string $temperature4
     * @return \StructType\PacketTemperature
     */
    public function setTemperature4($temperature4 = null)
    {
        // validation for constraint: string
        if (!is_null($temperature4) && !is_string($temperature4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($temperature4, true), gettype($temperature4)), __LINE__);
        }
        $this->Temperature4 = $temperature4;
        return $this;
    }
}
