<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Emergency ServiceType
 * @subpackage Services
 */
class Emergency extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EmergencyAlarm
     * Meta information extracted from the WSDL
     * - documentation: Acil durum alarmi, ek donanim (acil durum butonu veya acil durum pedali) bulunan araclarda manuel olarak uretilen alarmlari listeler. - Emergency alarm lists manually generated alarms on vehicles with additional equipment (with
     * emergency button or emergency pedal) | Acil durum alarmi, ek donanim (acil durum butonu veya acil durum pedali) bulunan araclarda manuel olarak uretilen alarmlari listeler. - Emergency alarm lists manually generated alarms on vehicles with additional
     * equipment (with emergency button or emergency pedal) | Acil durum alarmi, ek donanim (acil durum butonu veya acil durum pedali) bulunan araclarda manuel olarak uretilen alarmlari listeler. - Emergency alarm lists manually generated alarms on vehicles
     * with additional equipment (with emergency button or emergency pedal)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmergencyAlarm $parameters
     * @return \StructType\EmergencyAlarmResponse|bool
     */
    public function EmergencyAlarm(\StructType\EmergencyAlarm $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmergencyAlarm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EmergencyAlarmReturnObject
     * Meta information extracted from the WSDL
     * - documentation: Acil durum alarmi, ek donanim (acil durum butonu veya acil durum pedali) bulunan araclarda manuel olarak uretilen alarmlari listeler. EmergencyAlarm methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Emergency alarm
     * lists manually generated alarms on vehicles with additional equipment (with emergency button or emergency pedal), returns the result as XmlDocument type. | Acil durum alarmi, ek donanim (acil durum butonu veya acil durum pedali) bulunan araclarda
     * manuel olarak uretilen alarmlari listeler. EmergencyAlarm methodundan farkli olarak sonucu XmlDocument tipinde dondurur. - Emergency alarm lists manually generated alarms on vehicles with additional equipment (with emergency button or emergency
     * pedal), returns the result as XmlDocument type. | Acil durum alarmi, ek donanim (acil durum butonu veya acil durum pedali) bulunan araclarda manuel olarak uretilen alarmlari listeler. EmergencyAlarm methodundan farkli olarak sonucu XmlDocument
     * tipinde dondurur. - Emergency alarm lists manually generated alarms on vehicles with additional equipment (with emergency button or emergency pedal), returns the result as XmlDocument type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmergencyAlarmReturnObject $parameters
     * @return \StructType\EmergencyAlarmReturnObjectResponse|bool
     */
    public function EmergencyAlarmReturnObject(\StructType\EmergencyAlarmReturnObject $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmergencyAlarmReturnObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EmergencyAlarmResponse|\StructType\EmergencyAlarmReturnObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
